/*
    This file is a part of the program QLink.
    Copyright (C) Alexander Smirnov <asmirnov@rdm.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

	------------------------------------------------------------------


	This program allows to use the QDBM database (Copyright (C) 2000-2006 Mikio Hirabayashi)
	to be run from Wolfram Mathematica, 5.1 and higher.
	QDBM is also a free software that can be downloaded from http://qdbm.sourceforge.net/
	(Mathematica is unfortunately not)
	You will need to download QDBM to modify and recompile QLink.
	However, I have also compiled QLink on Linux (32 and 64 versions) and the binaries are self-consistant.
	The Windows binary of QLink requires two dll files, that should also come with QLink.

	------------------------------------------------------------------

	QLink.c is the main part of QLink and contains the realizations of the functions 
	that will be called from Mathematica and provide access to QDBM
	
*/


#include <depot.h>
#include <curia.h>
#include <stdlib.h>
#include <stdio.h>
#include "mathlink.h"


#define FILELIMIT 50
#define MAXVALUESIZE 500000000

	

	CURIA *curiahandle[FILELIMIT];
	int curiaopen[FILELIMIT];
	char *curianame[FILELIMIT];
	CURIA *curia;

	DEPOT *depothandle[FILELIMIT];
	int depotopen[FILELIMIT];
	char *depotname[FILELIMIT];
	DEPOT *depot;

	char *val;

extern void qget(char* s,char* key);
extern void qsafeget(char* s,char* key);
extern void qcheck(char* s,char* key);
extern void qremove(char* s,char* key);
extern void qput(char* s,char* key,char* value);
extern void qinit(char* s);
extern void qclose(char* s);
extern void qrepair(char* s);
extern void qlist(char* s);
extern void qread(char* s);




void PutErrorMessage(char* function,char* message) {
			fprintf(stderr, "%s: %s\n",function,message);
			MLPutFunction(stdlink,"CompoundExpression",2);
			MLPutFunction(stdlink,"Message",2);
			MLPutFunction(stdlink,"MessageName",2);
			MLPutSymbol(stdlink, function);
			MLPutString(stdlink, "failed");
			MLPutString(stdlink, message);
			MLPutSymbol(stdlink, "False");
}

int CuriaNumber(char* name) {
	int i;
	for (i=0;i<FILELIMIT;i++) {
		if((curiaopen[i]==1) && (strcmp(curianame[i],name)==0)) {
			return(i);
		}
	};
	return(-1);
}

int FreeCuriaNumber() {
	int i;
	for (i=0;i<FILELIMIT;i++) {
		if((curiaopen[i]==0)) {
			return(i);
		}
	};
	return(-1);
}

int DepotNumber(char* name) {
	int i;
	for (i=0;i<FILELIMIT;i++) {
		if((depotopen[i]==1) && (strcmp(depotname[i],name)==0)) {
			return(i);
		}
	};
	return(-1);
}

int FreeDepotNumber() {
	int i;
	for (i=0;i<FILELIMIT;i++) {
		if((depotopen[i]==0)) {
			return(i);
		}
	};
	return(-1);
}

int IsCuria(char* s) {
    char *t=s;
    
    while ((!(*t=='\n'))&&(!(*t=='\0'))) {t++;};
    t--;
    if ((*t=='\\')||(*t=='/')) {*t='\0';return 1;}
        else {return 0;};
}


void qget(char* s,char* key) {
		int i;
		//if (!val) {free(val);};
if(IsCuria(s)) {
	i=CuriaNumber(s);
	if (i>=0) {
		curia=curiahandle[i];
		if((i=crgetwb(curia, key, -1, 0, MAXVALUESIZE, val))<0){
			PutErrorMessage("QGet",dperrmsg(dpecode));
		} else {
			val[i]='\0';
			MLPutString(stdlink, val);
		}
	} else {
		PutErrorMessage("QGet","this database is not open");
	}
} else {
	i=DepotNumber(s);
	if (i>=0) {
		depot=depothandle[i];
		if((i=dpgetwb(depot, key, -1, 0, MAXVALUESIZE, val))<0){
			PutErrorMessage("QGet",dperrmsg(dpecode));
		} else {
			val[i]='\0';
			MLPutString(stdlink, val);
		}
	} else {
		PutErrorMessage("QGet","this file is not open");
	}



}
}

void qsafeget(char* s,char* key) {
		int i;
		//if (!val) {free(val);};
if(IsCuria(s)) {
	i=CuriaNumber(s);
	if (i>=0) {
		curia=curiahandle[i];
		if((i=crgetwb(curia, key, -1, 0, MAXVALUESIZE, val))<0){
			MLPutSymbol(stdlink, "False");
		} else {
			val[i]='\0';
			MLPutString(stdlink, val);
		}
	} else {
		PutErrorMessage("QSafeGet","this database is not open");
	}
} else {
    i=DepotNumber(s);
	if (i>=0) {
		depot=depothandle[i];
		if((i=dpgetwb(depot, key, -1, 0, MAXVALUESIZE, val))<0){
			MLPutSymbol(stdlink, "False");
		} else {
			val[i]='\0';
			MLPutString(stdlink, val);
		}
	} else {
		PutErrorMessage("QSafeGet","this file is not open");
	}

}
}

void qcheck(char* s,char* key) {
		int i;
if(IsCuria(s)) {
	i=CuriaNumber(s);
	if (i>=0) {
		curia=curiahandle[i];
		if((crvsiz(curia, key, -1))<0){
			MLPutSymbol(stdlink, "False");
		} else {
			//MLPutInteger(stdlink,crvsiz(curia, key, -1));
			//MLPutInteger(stdlink,crvsiz(curia, key, -1));
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QClose","this database is not open");
	}
} else {
	i=DepotNumber(s);
	if (i>=0) {
		depot=depothandle[i];
		if((dpvsiz(depot, key, -1))<0){
			MLPutString(stdlink, "False");
		} else {
			//MLPutInteger(stdlink,dpvsiz(depot, key, -1));
			//MLPutInteger(stdlink,dpvsiz(depot, key, -1));
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QClose","this file is not open");
	}


}
}


void qlist(char* s) {
    int i;
    char* key;

if(IsCuria(s)) {

	i=CuriaNumber(s);
	if (i>=0) {
		curia=curiahandle[i];
		if ((i=crrnum(curia))<0) {
			PutErrorMessage("QList",dperrmsg(dpecode));
		} else {
			MLPutFunction(stdlink,"List",i);
			if (i>0) {
				if(!criterinit(curia)){
					PutErrorMessage("QList",dperrmsg(dpecode));
				};
				while((key = criternext(curia, NULL)) != NULL){
					MLPutString(stdlink, key);
					free(key);
				};
			}
		}
	} else {
		PutErrorMessage("QList","this database is not open");
	}
} else {

	int i;
	char *key;
	i=DepotNumber(s);
	if (i>=0) {
		depot=depothandle[i];
		if ((i=dprnum(depot))<0) {
			PutErrorMessage("QList",dperrmsg(dpecode));
		} else {
			MLPutFunction(stdlink,"List",i);
			if (i>0) {
				if(!dpiterinit(depot)){
					PutErrorMessage("QList",dperrmsg(dpecode));
				};
				while((key = dpiternext(depot, NULL)) != NULL){
					MLPutString(stdlink, key);
					free(key);
				};
			}
		}
	} else {
		PutErrorMessage("QList","this file is not open");
	}


}


}


void qsize(char* s) {
	int i;
	double d;
	char *key;
if(IsCuria(s)) {

	i=CuriaNumber(s);
	if (i>=0) {
		curia=curiahandle[i];
		if ((d=crfsizd(curia))<0) {
			PutErrorMessage("QSize",dperrmsg(dpecode));
		} else {
			MLPutDouble(stdlink,d);
		}
	} else {
		PutErrorMessage("QSize","this database is not open");
	}

} else {
	i=DepotNumber(s);
	if (i>=0) {
		depot=depothandle[i];
		if ((d=dpfsiz(depot))<0) {
			PutErrorMessage("QSize",dperrmsg(dpecode));
		} else {
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QSize","this file is not open");
	}



}

}

void qremove(char* s,char* key) {
		int i;

if(IsCuria(s)) {
	i=CuriaNumber(s);
	if (i>=0) {
		curia=curiahandle[i];
		if(!(crout(curia, key, -1))){
			PutErrorMessage("QRemove",dperrmsg(dpecode));
		} else {
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QRemove","this database is not open");
	}
} else {
	i=DepotNumber(s);
	if (i>=0) {
		depot=depothandle[i];
		if(!(dpout(depot, key, -1))){
			PutErrorMessage("QDelete",dperrmsg(dpecode));
		} else {
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QRemove","this file is not open");
	}


}
}





void qput(char* s,char* key,char* value) {
		int i;

if(IsCuria(s)) {

	i=CuriaNumber(s);
	if (i>=0) {
		curia=curiahandle[i];
		if(!crput(curia, key, -1, value, -1, CR_DOVER)){
			PutErrorMessage("QPut",dperrmsg(dpecode));
		} else {
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QPut","this database is not open");
	}

} else {

	i=DepotNumber(s);
	if (i>=0) {
		depot=depothandle[i];
		if(!dpput(depot, key, -1, value, -1, DP_DOVER)){
			PutErrorMessage("QPut",dperrmsg(dpecode));
		} else {
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QPut","this file is not open");
	}


}

}

void qopen(char* s) {
	int i;

if(IsCuria(s)) {


	i=FreeCuriaNumber();
  if(!(curia = cropen(s, CR_OWRITER | CR_OCREAT, -1,256))){
	  PutErrorMessage("QOpen",dperrmsg(dpecode));
  } else
  {
	curiahandle[i]=curia;
	curiaopen[i]=1;
	curianame[i]=malloc(strlen(s)+1);
	strcpy(curianame[i],s);
	MLPutSymbol(stdlink, "True");}

} else {
	i=FreeDepotNumber();
  if(!(depot = dpopen(s, DP_OWRITER | DP_OCREAT, -1))){
	  PutErrorMessage("QOpen",dperrmsg(dpecode));
  } else
  {
	depothandle[i]=depot;
	depotopen[i]=1;
	depotname[i]=malloc(strlen(s)+1);
	strcpy(depotname[i],s);
	MLPutSymbol(stdlink, "True");}



}

}

void qread(char* s) {
	int i;

if(IsCuria(s)) {


	i=FreeCuriaNumber();
  if(!(curia = cropen(s, CR_OREADER, -1,256))){
	  PutErrorMessage("QRead",dperrmsg(dpecode));
  } else
  {
	curiahandle[i]=curia;
	curiaopen[i]=1;
	curianame[i]=malloc(strlen(s)+1);
	strcpy(curianame[i],s);
	MLPutSymbol(stdlink, "True");}

} else {
	i=FreeDepotNumber();
  if(!(depot = dpopen(s, CR_OREADER, -1))){
	  PutErrorMessage("QRead",dperrmsg(dpecode));
  } else
  {
	depothandle[i]=depot;
	depotopen[i]=1;
	depotname[i]=malloc(strlen(s)+1);
	strcpy(depotname[i],s);
	MLPutSymbol(stdlink, "True");}



}

}


void qremovedatabase(char* s) {
	int i;
if(IsCuria(s)) {

	i=CuriaNumber(s);
	if (i>=0) {
		PutErrorMessage("QRemoveDatabase","database is open and cannot be removed");
	} else {
		if(!crremove(s)){
			PutErrorMessage("QRemoveDatabase",dperrmsg(dpecode));
		} else
		{
			MLPutSymbol(stdlink, "True");
		}
	}
} else {
	i=DepotNumber(s);
	if (i>=0) {
		PutErrorMessage("QRemoveDatabase","database is open and cannot be removed");
	} else {
		if(!dpremove(s)){    
			PutErrorMessage("QRemoveDatabase",dperrmsg(dpecode));
		} else
		{
			MLPutSymbol(stdlink, "True");
		}
	}


}


}


void qrepair(char* s) {
if(IsCuria(s)) {

  if(!(crrepair(s))){
	  PutErrorMessage("QRepair",dperrmsg(dpecode));
  } else
  {
	MLPutSymbol(stdlink, "True");}

} else {

  if(!(dprepair(s))){
	  PutErrorMessage("QRepair",dperrmsg(dpecode));
  } else
  {
	MLPutSymbol(stdlink, "True");}

}

}

void qclose(char* s) {
	int i;
if(IsCuria(s)) {

	i=CuriaNumber(s);
	if (i>=0) {
		curia=curiahandle[i];
		if(!crclose(curia)){
			PutErrorMessage("QClose",dperrmsg(dpecode));
		} else
		{
			curiaopen[i]=0;
			free(curianame[i]);
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QClose","this database is not open");
	}
} else {
	i=DepotNumber(s);
	if (i>=0) {
		depot=depothandle[i];
		if(!dpclose(depot)){
			PutErrorMessage("QClose",dperrmsg(dpecode));
		} else
		{
			depotopen[i]=0;
			free(depotname[i]);
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QClose","this file is not open");
	}



}


}


int main(argc, argv)
	int argc; char* argv[];
{	int i;
	for (i=0;i<FILELIMIT;i++) {curiaopen[i]=0;};
	val=malloc(MAXVALUESIZE+1);
	return MLMain(argc, argv);
}


