!include makefile.inc
############# MathLink related paths and settings start: ####################
#### Specify here the fulll path to the Mathematica MathLink Developer Kit:
MLINKDIR = C:\Program Files\Wolfram Research\Mathematica\6.0\SystemFiles\Links\MathLink\DeveloperKit
MATHLINK = $(MLINKDIR)\$(SYS)\CompilerAdditions\mldev$(BIT)
MLIBDIR  = "$(MATHLINK)\lib"
MINCDIR = "$(MATHLINK)\Include"

#### Specify the system SYS
## for the 64bit platform:
## SYS = Windows-x86-64
## BIT = 64
## for the 32bit platform:
SYS = Windows
BIT = 32

### Specify the mathlink library name
## default setting
MLLIB = ml$(BIT)i3m.lib
## in case you compile with the mathlink that came with Mathematica 5.2 (only 32-bit version)
## MLLIB = ml32i2c.lib
############# MathLink related paths and settings end. ####################


###### Please specify the path to the QDBM
QDBM = "d:/tcport2009/src"


###### Please specify the path to the software developer kit ########
SDK = "C:\Program Files\Microsoft Platform SDK for Windows Server 2003 R2"
LIBDIR = $(SDK)\Lib
INCDIR = $(SDK)\Include


##### The names of the compilers and linkers
## The mathlink compiler tm -> c
MPREP    = "$(MATHLINK)\bin\mprep"
## the main compiler and related settings
CL = cl
CFLAGS =  /MD /TC /nologo /O2  -I$(INCDIR) -I$(QDBM) -I$(MINCDIR) 
## the linker and related settings
LINK = link
LFLAGS = /NOLOGO /SUBSYSTEM:Console /INCREMENTAL:no /LIBPATH:$(LIBDIR) /LIBPATH:$(MLIBDIR) /LIBPATH:$(QDBM)


##############################################################################
###### Do not change anything below this line.

LIBS = $(MLLIB) user$(BIT).lib kernel$(BIT).lib gdi$(BIT).lib tc.lib

QLink.exe : QLink.obj MathSide.obj
    LINK $(LFLAGS) QLink.obj MathSide.obj libcp.lib $(LIBS) /OUT:QLink.exe
    $(_VC_MANIFEST_EMBED_EXE)

.c.obj:
    cl /c $(CFLAGS) $<

QLink.obj : QLink.c
MathSide.obj : MathSide.c



MathSide.c : MathSide.tm
   $(MPREP) -o MathSide.c MathSide.tm 


!include makefile.targ.inc