/*
    This file is a part of the program QLink.
    Copyright (C) Alexander Smirnov <asmirnov@particle.uni-karlsruhe.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

	------------------------------------------------------------------
	
*/


#include <string.h>
#include <tcutil.h>
#include <tchdb.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <mathlink.h>
#include <unistd.h>

#define FILELIMIT 50
#define MAXVALUESIZE 500000000

	

	TCHDB *dbhandle[FILELIMIT];
	char *dbname[FILELIMIT];
	TCHDB *db;

	

int BucketSize;



void PutErrorMessage(const char* function,const char* message) {
			fprintf(stderr, "%s: %s\n",function,message);
			MLPutFunction(stdlink,"CompoundExpression",2);
			MLPutFunction(stdlink,"Message",2);
			MLPutFunction(stdlink,"MessageName",2);
			MLPutSymbol(stdlink, function);
			MLPutString(stdlink, "failed");
			MLPutString(stdlink, message);
			MLPutSymbol(stdlink, "False");
}

int DBNumber(char* name) {
	int i;
	for (i=0;i<FILELIMIT;i++) {
		if((dbname[i]!=NULL) && (strcmp(dbname[i],name)==0)) {
			return(i);
		}
	};
	return(-1);
}

int FreeDBNumber() {
	int i;
	for (i=0;i<FILELIMIT;i++) {
		if((dbname[i]==NULL)) {
			return(i);
		}
	};
	return(-1);
}

#define checkSlash(s) if(*(s)!= '\0'){char *sss=(s); for(;*sss!='\0';sss++);if(*(sss-1)=='/')*(sss-1)='\0';}

void qsetbucketsize(int i) {
  BucketSize=i;
  MLPutSymbol(stdlink, "True");
}


void qget(char* s,char* key) {
  int i;
  char* val;
  checkSlash(s);
 
	i=DBNumber(s);
	if (i>=0) {
		db=dbhandle[i];
		if(!(val=tchdbget2(db, key))){
			PutErrorMessage("QGet",tchdberrmsg(tchdbecode(db)));
		} else {			
			MLPutString(stdlink, val);
			free(val);
		}
	} else {
		PutErrorMessage("QGet","this database is not open");
	}

}



void qsafeget(char* s,char* key) {
  int i;
  char* val;
  checkSlash(s);
  
  i=DBNumber(s);
  if (i>=0) {
    db=dbhandle[i];
    if(!(val=tchdbget2(db, key))){
      MLPutSymbol(stdlink, "False");
    } else {
      MLPutString(stdlink, val);
      free(val);
    }
  } else {
    PutErrorMessage("QSafeGet","this database is not open");
  }

}

void qcheck(char* s,char* key) {
  
		int i;
		checkSlash(s);
	i=DBNumber(s);
	if (i>=0) {
		db=dbhandle[i];
		if((tchdbvsiz(db, key, strlen(key)))<0){
			MLPutSymbol(stdlink, "False");
		} else {
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QClose","this database is not open");
	}
}


void qlist(char* s) {
    int i;
    char* key;

    checkSlash(s);
  

	i=DBNumber(s);
	if (i>=0) {
		db=dbhandle[i];
				if ((i=tchdbrnum(db))<0) {
			PutErrorMessage("QList",tchdberrmsg(tchdbecode(db)));
			} else {
			MLPutFunction(stdlink,"List",i);
			if (i>0) {
				if(!tchdbiterinit(db)){
					PutErrorMessage("QList",tchdberrmsg(tchdbecode(db)));
				};
				while((key = tchdbiternext2(db)) != NULL){
					MLPutString(stdlink, key);
					free(key);
				};
			}
			}
	} else {
		PutErrorMessage("QList","this database is not open");
	}
}


void qsize(char* s) {
  int i;
  double d;
  checkSlash(s);
  i=DBNumber(s);
  if (i>=0) {
    db=dbhandle[i];
    if(d=(tchdbfsiz(db))<0){
      PutErrorMessage("QSize",tchdberrmsg(tchdbecode(db)));
    } else {
      MLPutDouble(stdlink,d);
    }
  } else {
    PutErrorMessage("QSize","this database is not open");
  }
}


void qremove(char* s,char* key) {
  	int i;
	checkSlash(s);
	i=DBNumber(s);
	if (i>=0) {
		db=dbhandle[i];
		if(!(tchdbout(db, key, strlen(key)))){
			PutErrorMessage("QRemove",tchdberrmsg(tchdbecode(db)));
		} else {
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QRemove","this database is not open");
	}
}





void qput(char* s,char* key,char* value) {
		int i;
		checkSlash(s);

	i=DBNumber(s);
	if (i>=0) {
		db=dbhandle[i];
		if(!tchdbput(db, key, strlen(key), value, strlen(value))){
			PutErrorMessage("QPut",tchdberrmsg(tchdbecode(db)));
		} else {
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QPut","this file is not open");
	}

}

void qopen(char* s) {
	int i;
	checkSlash(s);
	i=FreeDBNumber();
	if (i<0) {PutErrorMessage("QOpen","Too many open files!");return;};
	dbhandle[i]=tchdbnew();
	db=dbhandle[i];
	if(!(tchdbtune(db,pow(2,BucketSize),-1,-1,HDBTLARGE))) {
	PutErrorMessage("QOpen",tchdberrmsg(tchdbecode(db)));
	}
  if(!(tchdbopen(db,s, HDBOWRITER | HDBOCREAT | HDBONOLCK))){
	  PutErrorMessage("QOpen",tchdberrmsg(tchdbecode(db)));
  } else
  {
  
	
	dbname[i]=malloc(strlen(s)+1);
	strcpy(dbname[i],s);
	MLPutSymbol(stdlink, "True");}

}



void qread(char* s) {
  int i;
  checkSlash(s);
  i=FreeDBNumber();
  if (i<0) {PutErrorMessage("QOpen","Too many open files!");return;};
  dbhandle[i]=tchdbnew();
  db=dbhandle[i];
  tchdbtune(db,pow(2,BucketSize),-1,-1,HDBTLARGE);
  if(!(tchdbopen(db,s, HDBOREADER | HDBONOLCK))){
    PutErrorMessage("QRead",tchdberrmsg(tchdbecode(db)));
  } else
    {

     
      dbname[i]=malloc(strlen(s)+1);
      strcpy(dbname[i],s);
      MLPutSymbol(stdlink, "True");}


}


void qremovedatabase(char* s) {
  
	int i;
	checkSlash(s);
	i=DBNumber(s);
	if (i>=0) {
		PutErrorMessage("QRemoveDatabase","database is open and cannot be removed");
	} else {
		if(!(unlink(s)==0)){
			PutErrorMessage("QRemoveDatabase","Can't unlink file");
		} else
		{
			MLPutSymbol(stdlink, "True");
		}
	}
}


void qrepair(char* s) {
  PutErrorMessage("QRepair","This method is not supported by the TokyoCabinet!");
  
}

void qclose(char* s) 
{     int i;
 checkSlash(s);
	i=DBNumber(s);
	if (i>=0) {
		db=dbhandle[i];
		if(!tchdbclose(db)){
			PutErrorMessage("QClose",tchdberrmsg(tchdbecode(db)));
		} else
		{
		 
			free(dbname[i]);
			dbname[i]=NULL;
			tchdbdel(dbhandle[i]);
			MLPutSymbol(stdlink, "True");
		}
	} else {
		PutErrorMessage("QClose","this file is not open");
	}

}


int main(argc, argv)
	int argc; char* argv[];
{	int i;
 BucketSize=21; 
	for (i=0;i<FILELIMIT;i++) {dbname[i]=NULL;};
	/*	val=malloc(MAXVALUESIZE+1);*/
	return MLMain(argc, argv);
}


