(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    144112,       3963]
NotebookOptionsPosition[    129578,       3566]
NotebookOutlinePosition[    129936,       3582]
CellTagsIndexPosition[    129893,       3579]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData["Quit"], "Input",
 CellChangeTimes->{{3.569308813352964*^9, 3.569308813745512*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.569310056056975*^9, 3.569310064345089*^9}, {
  3.570677078976544*^9, 3.5706770894736547`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "[", "\"\<FIRE_4.0.0.m\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.569308660505506*^9, 3.5693086884557667`*^9}, 
   3.5693100901292753`*^9, {3.5706770643103724`*^9, 3.570677066537859*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"FIRE, version 4.0.0\"\>"], "Print",
 CellChangeTimes->{3.569313353231852*^9, 3.570677091861683*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"UsingIBP: \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm["UsingIBP: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{3.569313353231852*^9, 3.57067709188227*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"DatabaseUsage: \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["DatabaseUsage: ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.569313353231852*^9, 3.570677091884018*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"UsingFermat: \"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm["UsingFermat: ", False],
  Editable->False]], "Print",
 CellChangeTimes->{3.569313353231852*^9, 3.570677091885922*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LeeIdeas: \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm["LeeIdeas: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{3.569313353231852*^9, 3.5706770918874617`*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Internal", "=", 
   RowBox[{"{", "k", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"External", "=", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Propagators", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"k", "^", "2"}]}], ",", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "p1"}], ")"}], "^", "2"}]}], ",", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "p1", "+", "p2"}], ")"}], "^", "2"}]}], ",", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "p1", "+", "p2", "+", "p4"}], ")"}], "^", "2"}]}]}],
     "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Replacements", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"p1", "^", "2"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"p2", "^", "2"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"p4", "^", "2"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"p1", " ", "p2"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "S"}], "/", "2"}]}], ",", 
     RowBox[{
      RowBox[{"p2", " ", "p4"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "T"}], "/", "2"}]}], ",", 
     RowBox[{
      RowBox[{"p1", " ", "p4"}], "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"S", "+", "T"}], ")"}], "/", "2"}]}], ",", 
     RowBox[{"S", "\[Rule]", "1"}], ",", 
     RowBox[{"T", "\[Rule]", "1"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.569308691102756*^9, 3.5693088102623587`*^9}, {
   3.5693088440209913`*^9, 3.569308854930416*^9}, {3.5693103876960487`*^9, 
   3.5693103987671223`*^9}, 3.569310495507863*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrepareIBP", "[", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"startinglist", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Outer", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"IBP", "[", 
           RowBox[{"#1", ",", "#2"}], "]"}], "//.", "Replacements"}], ")"}], 
        "&"}], ",", "Internal", ",", 
       RowBox[{"Join", "[", 
        RowBox[{"Internal", ",", "External"}], "]"}]}], "]"}], ",", "1"}], 
    "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.569308867107854*^9, 3.569308877554669*^9}, 
   3.569308968641765*^9, 3.569310386383347*^9}],

Cell[BoxData["\<\"Prepared\"\>"], "Print",
 CellChangeTimes->{{3.569308856724534*^9, 3.569308878544139*^9}, 
   3.569308975545514*^9, 3.569310068438328*^9, 3.56931016886633*^9, {
   3.569310497974832*^9, 3.569310499118799*^9}, 3.570677094489729*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prepare", "[", 
  RowBox[{"AutoDetectRestrictions", "\[Rule]", "True"}], "]"}]], "Input",
 CellChangeTimes->{{3.569308886352817*^9, 3.5693088957579393`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dimension set to \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["Dimension set to ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308896208707*^9, 3.569308976946743*^9, 
  3.569310069835264*^9, 3.569310169895854*^9, 3.569310500417026*^9, 
  3.570677095910187*^9}],

Cell[BoxData["\<\"No symmetries\"\>"], "Print",
 CellChangeTimes->{3.569308896208707*^9, 3.569308976946743*^9, 
  3.569310069835264*^9, 3.569310169895854*^9, 3.569310500417026*^9, 
  3.570677095921557*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BuildAll", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.569308901327798*^9, 3.569308912059865*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sectors in the area :\"\>", "\[InvisibleSpace]", "16"}],
  SequenceForm["Sectors in the area :", 16],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677097786141*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Non-trivial sectors in the area :\"\>", "\[InvisibleSpace]", 
   "11"}],
  SequenceForm["Non-trivial sectors in the area :", 11],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677097802775*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Non-trivial sectors up to a symmetry in the area :\"\>", 
   "\[InvisibleSpace]", "11"}],
  SequenceForm["Non-trivial sectors up to a symmetry in the area :", 11],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677097830801*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Bases built in \"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\" sectors\"\>"}],
  SequenceForm["Bases built in ", 0, " sectors"],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770978517237`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Nothing in \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\" sectors\"\>"}],
  SequenceForm["Nothing in ", 11, " sectors"],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770978723183`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Failed to find an ordering for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Failed to find an ordering for ", {1, 1, 1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677097891227*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Failed to find an ordering for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Failed to find an ordering for ", {-1, 1, 1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770979125853`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Failed to find an ordering for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Failed to find an ordering for ", {1, -1, 1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677097932537*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Saving one-element basis for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}],
  SequenceForm["Saving one-element basis for ", {1, 1, -1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677097954361*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Failed to find an ordering for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}],
  SequenceForm["Failed to find an ordering for ", {1, 1, 1, -1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770979737263`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Failed to find an ordering for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["Failed to find an ordering for ", {-1, -1, 1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770979962177`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Failed to find an ordering for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}],
  SequenceForm["Failed to find an ordering for ", {-1, 1, -1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098017866*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Failed to find an ordering for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}],
  SequenceForm["Failed to find an ordering for ", {-1, 1, 1, -1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098039939*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Saving one-element basis for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}],
  SequenceForm["Saving one-element basis for ", {1, -1, -1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770980614367`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Failed to find an ordering for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}],
  SequenceForm["Failed to find an ordering for ", {1, -1, 1, -1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770980980797`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Saving one-element basis for \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}],
  SequenceForm["Saving one-element basis for ", {1, 1, -1, -1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098120479*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sectors in the area :\"\>", "\[InvisibleSpace]", "16"}],
  SequenceForm["Sectors in the area :", 16],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770981429863`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Non-trivial sectors in the area :\"\>", "\[InvisibleSpace]", 
   "11"}],
  SequenceForm["Non-trivial sectors in the area :", 11],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098166593*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Non-trivial sectors up to a symmetry in the area :\"\>", 
   "\[InvisibleSpace]", "11"}],
  SequenceForm["Non-trivial sectors up to a symmetry in the area :", 11],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770981898623`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Bases built in \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" sectors\"\>"}],
  SequenceForm["Bases built in ", 3, " sectors"],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098211256*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Nothing in \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" sectors\"\>"}],
  SequenceForm["Nothing in ", 8, " sectors"],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098233075*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770982568827`*^9}],

Cell[BoxData["\<\"1 additional minus\"\>"], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.57067709827883*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1"}], "}"}], "}"}]], "Print",\

 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098300215*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098323181*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", 
    RowBox[{"-", "1"}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098344717*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\" additional minuses\"\>"}],
  SequenceForm[2, " additional minuses"],
  Editable->False]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.5706770983636847`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}], ",", "1", ",", "1"}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098385438*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1", ",", 
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098405971*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1", ",", "1", ",", 
    RowBox[{"-", "1"}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098427115*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}], ",", "1", ",", 
    RowBox[{"-", "1"}]}], "}"}], "}"}]], "Print",
 CellChangeTimes->{3.569308912650063*^9, 3.56930897796454*^9, 
  3.569310070508811*^9, 3.5693101708442163`*^9, 3.569310501771698*^9, 
  3.570677098448669*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SaveSBases", "[", "\"\<box\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.569310073432465*^9, 3.569310080921268*^9}, {
  3.569310177262278*^9, 3.569310178034169*^9}}],

Cell[BoxData["\<\"Saving the bases\"\>"], "Print",
 CellChangeTimes->{3.5693100811777973`*^9, 3.5693101783863153`*^9, 
  3.569310504722397*^9, 3.570677103078986*^9}]
}, Open  ]],

Cell[BoxData["Quit"], "Input",
 CellChangeTimes->{{3.5693100821837463`*^9, 3.569310082477262*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.569310056056975*^9, 3.569310064345089*^9}, {
  3.5706771070536823`*^9, 3.570677119802376*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "[", "\"\<FIRE_4.0.0.m\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.569308660505506*^9, 3.5693086884557667`*^9}, 
   3.5693100901292753`*^9, {3.570677122771185*^9, 3.570677124671975*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"FIRE, version 4.0.0\"\>"], "Print",
 CellChangeTimes->{
  3.569308688804391*^9, {3.569308815833359*^9, 3.569308851445272*^9}, 
   3.5693089726905737`*^9, 3.569310066320315*^9, {3.569310098023608*^9, 
   3.56931015079423*^9}, 3.569310184348373*^9, 3.569310509079418*^9, 
   3.5693105871392803`*^9, 3.56931119620444*^9, 3.569311310674163*^9, 
   3.569311531679481*^9, 3.5693127543194036`*^9, 3.569312956443667*^9, 
   3.5693129891015873`*^9, 3.56931304471805*^9, 3.56931317070273*^9, 
   3.569313412508919*^9, 3.570677125164794*^9, 3.5706773336398067`*^9, 
   3.570678947302002*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"UsingIBP: \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm["UsingIBP: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.569308688804391*^9, {3.569308815833359*^9, 3.569308851445272*^9}, 
   3.5693089726905737`*^9, 3.569310066320315*^9, {3.569310098023608*^9, 
   3.56931015079423*^9}, 3.569310184348373*^9, 3.569310509079418*^9, 
   3.5693105871392803`*^9, 3.56931119620444*^9, 3.569311310674163*^9, 
   3.569311531679481*^9, 3.5693127543194036`*^9, 3.569312956443667*^9, 
   3.5693129891015873`*^9, 3.56931304471805*^9, 3.56931317070273*^9, 
   3.569313412508919*^9, 3.570677125164794*^9, 3.5706773336398067`*^9, 
   3.57067894737162*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"DatabaseUsage: \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["DatabaseUsage: ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.569308688804391*^9, {3.569308815833359*^9, 3.569308851445272*^9}, 
   3.5693089726905737`*^9, 3.569310066320315*^9, {3.569310098023608*^9, 
   3.56931015079423*^9}, 3.569310184348373*^9, 3.569310509079418*^9, 
   3.5693105871392803`*^9, 3.56931119620444*^9, 3.569311310674163*^9, 
   3.569311531679481*^9, 3.5693127543194036`*^9, 3.569312956443667*^9, 
   3.5693129891015873`*^9, 3.56931304471805*^9, 3.56931317070273*^9, 
   3.569313412508919*^9, 3.570677125164794*^9, 3.5706773336398067`*^9, 
   3.570678947385854*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"UsingFermat: \"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm["UsingFermat: ", False],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.569308688804391*^9, {3.569308815833359*^9, 3.569308851445272*^9}, 
   3.5693089726905737`*^9, 3.569310066320315*^9, {3.569310098023608*^9, 
   3.56931015079423*^9}, 3.569310184348373*^9, 3.569310509079418*^9, 
   3.5693105871392803`*^9, 3.56931119620444*^9, 3.569311310674163*^9, 
   3.569311531679481*^9, 3.5693127543194036`*^9, 3.569312956443667*^9, 
   3.5693129891015873`*^9, 3.56931304471805*^9, 3.56931317070273*^9, 
   3.569313412508919*^9, 3.570677125164794*^9, 3.5706773336398067`*^9, 
   3.57067894739966*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LeeIdeas: \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm["LeeIdeas: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.569308688804391*^9, {3.569308815833359*^9, 3.569308851445272*^9}, 
   3.5693089726905737`*^9, 3.569310066320315*^9, {3.569310098023608*^9, 
   3.56931015079423*^9}, 3.569310184348373*^9, 3.569310509079418*^9, 
   3.5693105871392803`*^9, 3.56931119620444*^9, 3.569311310674163*^9, 
   3.569311531679481*^9, 3.5693127543194036`*^9, 3.569312956443667*^9, 
   3.5693129891015873`*^9, 3.56931304471805*^9, 3.56931317070273*^9, 
   3.569313412508919*^9, 3.570677125164794*^9, 3.5706773336398067`*^9, 
   3.570678947413127*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LoadSBases", "[", 
   RowBox[{"\"\<box\>\"", ",", "2"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.569310117653887*^9, 3.56931015546128*^9}}],

Cell[BoxData["\<\"SBases loaded\"\>"], "Print",
 CellChangeTimes->{{3.569310127909254*^9, 3.569310185613509*^9}, 
   3.569310510083799*^9, 3.5693105874852457`*^9, 3.56931119848715*^9, 
   3.5693133675879383`*^9, 3.569313413845705*^9, 3.570677127446867*^9, 
   3.570677335159953*^9, 3.570678948126322*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Burn", "[", "]"}]], "Input",
 CellChangeTimes->{{3.569310109559018*^9, 3.569310110532069*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.5693101117700987`*^9, 3.569310128917901*^9}, 
   3.5693101867006197`*^9, 3.569310510850979*^9, 3.5693105884579563`*^9, 
   3.569311199320209*^9, 3.5693133683323107`*^9, 3.5693134147014427`*^9, 
   3.570677128270722*^9, 3.570677336123269*^9, 3.570678948877388*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"UsingFermat", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "FermatPath", "=", 
   "\"\</home/sander/MyFiles/Programs/fermat64/ferl64/feris64\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FLinkPath", "=", "\"\<FLink64\>\""}], ";"}]}], "Input",
 CellChangeTimes->{3.570677178047948*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"DatabaseUsage", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DataPath", "=", "\"\<tmp\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QLinkPath", "=", "\"\<KLink64\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.5706772170067587`*^9, 3.570677285054925*^9}, {
  3.570677321436062*^9, 3.570677327814516*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"FLink created! You can read information on FInit, FEval, \
FAddVars and FClose\"\>"], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789520645847`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"EVALUATING \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}]}], "}"}]}],
  SequenceForm["EVALUATING ", {2, {2, 2, 2, 2}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.57067895214193*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,1,1,1}}\"\>"}],
  SequenceForm["Working in sector ", 1, "/", 11, ": ", "{2,{1,1,1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789521741056`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 1, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952206599*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"4", ",", "0"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{4, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952237309*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952267717*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "16", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.014318`4.607427351577781", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 16, " IBP's: ", 
   0.014318`4.607427351577781, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.57067895229854*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "14", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.065775`5.269605850253709", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  14, " new relations produced: ", 0.065775`5.269605850253709, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952354847*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952385228*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "25", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.019833`4.748933405376597", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 25, " IBP's: ", 
   0.019833`4.748933405376597, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952418047*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.094929`5.428943899453476", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.094929`5.428943899453476, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952449318*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952479681*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "44", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.034659`4.991361021558024", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 44, " IBP's: ", 
   0.034659`4.991361021558024, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952510483*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IRREDUCIBLE INTEGRAL: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["IRREDUCIBLE INTEGRAL: ", {2, {1, 1, 1, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952542*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "15", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.071191`5.303970086888535", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  15, " new relations produced: ", 0.071191`5.303970086888535, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952573948*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952605872*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,1,1,-1}}\"\>"}],
  SequenceForm["Working in sector ", 2, "/", 11, ": ", "{2,{1,1,1,-1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952636983*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 13, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789526645517`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "0"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{3, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952697152*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952730028*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "27", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.019676`4.745481807383267", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 27, " IBP's: ", 
   0.019676`4.745481807383267, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952763237*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.093114`5.42055997700836", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  23, " new relations produced: ", 0.093114`5.42055997700836, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952796727*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952828951*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "33", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.021845`4.790897042541559", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 33, " IBP's: ", 
   0.021845`4.790897042541559, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952862114*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.025832`4.863703025505077", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  8, " new relations produced: ", 0.025832`4.863703025505077, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952919859*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678952953619*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{-1,1,1,1}}\"\>"}],
  SequenceForm["Working in sector ", 3, "/", 11, ": ", "{2,{-1,1,1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789529874372`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 8, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789530189037`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{2, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789530513372`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953083597*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "28", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.029257`4.917774785201806", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 28, " IBP's: ", 
   0.029257`4.917774785201806, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953116446*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.099322`5.44859044964852", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  23, " new relations produced: ", 0.099322`5.44859044964852, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789531486597`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953228446*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "36", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.021617`4.786340416052739", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 36, " IBP's: ", 
   0.021617`4.786340416052739, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.57067895323129*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "18", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.072852`5.313986472416545", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  18, " new relations produced: ", 0.072852`5.313986472416545, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953263509*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953295576*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,-1,1,1}}\"\>"}],
  SequenceForm["Working in sector ", 4, "/", 11, ": ", "{2,{1,-1,1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953327969*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 13, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953362055*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "0"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{3, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.57067895339412*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789534259653`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "27", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.018639`4.721967601828748", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 27, " IBP's: ", 
   0.018639`4.721967601828748, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789534848213`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.09858`5.445333807314674", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  23, " new relations produced: ", 0.09858`5.445333807314674, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789535159283`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953548345*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "34", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.021616`4.786320325173924", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 34, " IBP's: ", 
   0.021616`4.786320325173924, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.57067895358182*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.075671`5.330474466747438", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.075671`5.330474466747438, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789536143913`*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953646171*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,1,-1,1}}\"\>"}],
  SequenceForm["Working in sector ", 5, "/", 11, ": ", "{2,{1,1,-1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953679064*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "19", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.021196`4.7777989043382645", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm[
  19, " new relations produced: ", 0.021196`4.7777989043382645, " seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953711753*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{-1,1,1,-1}}\"\>"}],
  SequenceForm["Working in sector ", 6, "/", 11, ": ", "{2,{-1,1,1,-1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953768038*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 14, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953800412*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{3, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789538326197`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789538651237`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "31", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.020148`4.755776935681642", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 31, " IBP's: ", 
   0.020148`4.755776935681642, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953897078*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.092443`5.417419024443075", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  23, " new relations produced: ", 0.092443`5.417419024443075, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953930088*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678953963036*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "28", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017447`4.69326575456457", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 28, " IBP's: ", 
   0.017447`4.69326575456457, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789539947147`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.113352`5.50597418078428", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.113352`5.50597418078428, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954056416*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954089023*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "26", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017193`4.686896656673382", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 26, " IBP's: ", 
   0.017193`4.686896656673382, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789541222982`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.089499`5.403363176332461", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.089499`5.403363176332461, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954154241*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954186954*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "20", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.013746`4.589721333069012", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 20, " IBP's: ", 
   0.013746`4.589721333069012, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789542192087`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "15", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.102521`5.462357827180274", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  15, " new relations produced: ", 0.102521`5.462357827180274, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954252493*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954292753*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "33", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.024133`4.834156306389463", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 33, " IBP's: ", 
   0.024133`4.834156306389463, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789543252373`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "14", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.059936`5.229232749191115", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  14, " new relations produced: ", 0.059936`5.229232749191115, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789543582277`*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.57067895439048*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,-1,1,-1}}\"\>"}],
  SequenceForm["Working in sector ", 7, "/", 11, ": ", "{2,{1,-1,1,-1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954422967*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 13, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954456635*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{3, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954489665*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954522861*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "31", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.019608`4.743978291739992", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 31, " IBP's: ", 
   0.019608`4.743978291739992, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954581338*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "26", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.09568`5.4323661601403055", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  26, " new relations produced: ", 0.09568`5.4323661601403055, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789546139793`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789546452217`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "28", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.016473`4.668317691925006", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 28, " IBP's: ", 
   0.016473`4.668317691925006, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954678184*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "21", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.115758`5.515096008182046", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  21, " new relations produced: ", 0.115758`5.515096008182046, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789547123127`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954744007*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "26", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017747`4.700669942799143", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 26, " IBP's: ", 
   0.017747`4.700669942799143, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789547767572`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IRREDUCIBLE INTEGRAL: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm["IRREDUCIBLE INTEGRAL: ", {2, {1, 0, 1, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954809407*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.016077`4.657750005259243", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  6, " new relations produced: ", 0.016077`4.657750005259243, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954864314*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954866946*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{-1,-1,1,1}}\"\>"}],
  SequenceForm["Working in sector ", 8, "/", 11, ": ", "{2,{-1,-1,1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954869919*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 22, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954873384*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{3, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954875964*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789548783407`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "32", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.022695`4.807475180574837", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 32, " IBP's: ", 
   0.022695`4.807475180574837, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954880992*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.104862`5.472163130114956", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  23, " new relations produced: ", 0.104862`5.472163130114956, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954883555*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954915743*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "29", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017763`4.7010613092976286", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 29, " IBP's: ", 
   0.017763`4.7010613092976286, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678954947741*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.127188`5.555991131698099", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.127188`5.555991131698099, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789549801207`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.57067895501266*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "28", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017468`4.6937881767452705", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 28, " IBP's: ", 
   0.017468`4.6937881767452705, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.57067895504494*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.106716`5.479774531859259", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.106716`5.479774531859259, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789550770473`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955135784*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "22", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.013833`4.592461370435039", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 22, " IBP's: ", 
   0.013833`4.592461370435039, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955167644*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "15", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.120719`5.533320622713135", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  15, " new relations produced: ", 0.120719`5.533320622713135, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789551997843`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789552319736`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "36", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.024524`4.841136300951173", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 36, " IBP's: ", 
   0.024524`4.841136300951173, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789552644863`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "16", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.066694`5.27563175868539", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  16, " new relations produced: ", 0.066694`5.27563175868539, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955295787*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955318166*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{-1,1,-1,1}}\"\>"}],
  SequenceForm["Working in sector ", 9, "/", 11, ": ", "{2,{-1,1,-1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955342966*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 17, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955386798*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm["Maximal levels: ", {{1, 1}, {4, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955413443*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955437687*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "32", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.020527`4.763870475811096", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 32, " IBP's: ", 
   0.020527`4.763870475811096, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955464278*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "26", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.126344`5.5530996158598365", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  26, " new relations produced: ", 0.126344`5.5530996158598365, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955488913*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IRREDUCIBLE INTEGRAL: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["IRREDUCIBLE INTEGRAL: ", {2, {0, 1, 0, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789555152483`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789555390472`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "29", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.016916`4.6798426699708395", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 29, " IBP's: ", 
   0.016916`4.6798426699708395, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789555648613`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "21", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.125211`5.549187477557689", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  21, " new relations produced: ", 0.125211`5.549187477557689, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.57067895559107*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955615448*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "28", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.0176`4.697057661310121", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 28, " IBP's: ", 
   0.0176`4.697057661310121, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955658671*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "21", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.098171`5.443528208370251", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  21, " new relations produced: ", 0.098171`5.443528208370251, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.57067895568382*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955710465*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "36", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.022676`4.807111441814904", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 36, " IBP's: ", 
   0.022676`4.807111441814904, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955734599*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.044866`5.103462345503664", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  12, " new relations produced: ", 0.044866`5.103462345503664, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789557615747`*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955787078*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,1,-1,-1}}\"\>"}],
  SequenceForm["Working in sector ", 10, "/", 11, ": ", "{2,{1,1,-1,-1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789558117456`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "9", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.007658`4.335660355507634", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm[
  9, " new relations produced: ", 0.007658`4.335660355507634, " seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955836095*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,-1,-1,1}}\"\>"}],
  SequenceForm["Working in sector ", 11, "/", 11, ": ", "{2,{1,-1,-1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789558633223`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "19", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.01641`4.666653574549064", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm[
  19, " new relations produced: ", 0.01641`4.666653574549064, " seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789558911047`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GENERATING \"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" NEW RELATIONS: \"\>", "\[InvisibleSpace]", 
   "2.994824`6.9279162983265605", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "GENERATING ", 28, " NEW RELATIONS: ", 2.994824`6.9279162983265605, 
   " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955935307*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SORTING THE LIST OF \"\>", "\[InvisibleSpace]", "422", 
   "\[InvisibleSpace]", "\<\" INTEGRALS: \"\>", "\[InvisibleSpace]", 
   "0.019862`4.749567971050658", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "SORTING THE LIST OF ", 422, " INTEGRALS: ", 0.019862`4.749567971050658, 
   " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678955962411*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Substituting \"\>", "\[InvisibleSpace]", "422", 
   "\[InvisibleSpace]", "\<\" values: \"\>", "\[InvisibleSpace]", 
   "0.119861`5.530222890189246", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Substituting ", 422, " values: ", 0.119861`5.530222890189246, " seconds."],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.5706789559880943`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Total time: \"\>", "\[InvisibleSpace]", 
   "3.261374`6.964945598135327", "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["Total time: ", 3.261374`6.964945598135327, " seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5706771850908213`*^9, {3.570677237660974*^9, 3.570677264224341*^9}, 
   3.5706773473100357`*^9, 3.570678956015418*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "8"}], "+", "d"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "6"}], "+", "d"}], ")"}]}]], 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", "d"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", "d"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "d"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "824"}], "+", 
       RowBox[{"264", " ", "d"}], "-", 
       RowBox[{"28", " ", 
        SuperscriptBox["d", "2"]}], "+", 
       SuperscriptBox["d", "3"]}], ")"}], " ", 
     RowBox[{"G", "[", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}]}], 
  "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "8"}], "+", "d"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "6"}], "+", "d"}], ")"}]}]], 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "7"}], "+", "d"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", "d"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "d"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "824"}], "+", 
      RowBox[{"264", " ", "d"}], "-", 
      RowBox[{"28", " ", 
       SuperscriptBox["d", "2"]}], "+", 
      SuperscriptBox["d", "3"]}], ")"}], " ", 
    RowBox[{"G", "[", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}]}], "]"}]}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "7"}], "+", "d"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "5"}], "+", "d"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"128", "-", 
     RowBox[{"22", " ", "d"}], "+", 
     SuperscriptBox["d", "2"]}], ")"}], " ", 
   RowBox[{"G", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
    "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.570677188986142*^9, {3.570677237662538*^9, 3.5706772644347267`*^9}, 
   3.5706773593790817`*^9, 3.570678956041605*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "=", 
  RowBox[{"GetII", "/@", 
   RowBox[{"IrreducibleIntegrals", "[", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.569310262075305*^9, 3.569310263300067*^9}, {
  3.5693102937286463`*^9, 3.569310307535859*^9}, {3.569310354708947*^9, 
  3.569310372680049*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.56931030790515*^9, {3.5693103602396173`*^9, 3.569310373052964*^9}, 
   3.56931051752722*^9, 3.569310547681815*^9, 3.569310594088564*^9, 
   3.569311208288327*^9, 3.5706773793466377`*^9, 3.570678956203663*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Internal", "=", 
   RowBox[{"{", "k", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"External", "=", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p4"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Propagators", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"k", "^", "2"}]}], ",", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "p1"}], ")"}], "^", "2"}]}], ",", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "p1", "+", "p2"}], ")"}], "^", "2"}]}], ",", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "p1", "+", "p2", "+", "p4"}], ")"}], "^", "2"}]}]}],
     "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Replacements", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"p1", "^", "2"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"p2", "^", "2"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"p4", "^", "2"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"p1", " ", "p2"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "S"}], "/", "2"}]}], ",", 
     RowBox[{
      RowBox[{"p2", " ", "p4"}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "T"}], "/", "2"}]}], ",", 
     RowBox[{
      RowBox[{"p1", " ", "p4"}], "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"S", "+", "T"}], ")"}], "/", "2"}]}], ",", 
     RowBox[{"S", "\[Rule]", "1"}], ",", 
     RowBox[{"T", "\[Rule]", "1"}]}], "}"}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRules", "[", "list", "]"}]], "Input",
 CellChangeTimes->{{3.569310328388961*^9, 3.569310332815854*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Input: \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", output: \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Input: ", 3, ", output: ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.569310333333745*^9, {3.5693103667763777`*^9, 3.569310374111384*^9}, 
   3.569310405296096*^9, {3.5693104600158854`*^9, 3.569310468935979*^9}, {
   3.569310524386519*^9, 3.569310560331092*^9}, {3.569310596832703*^9, 
   3.5693106047594013`*^9}, 3.569311210920958*^9, 3.569311664991914*^9, {
   3.570677408925308*^9, 3.5706774318613157`*^9}, 3.570678959726779*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"G", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}]}], "]"}], "\[Rule]", 
   
   RowBox[{"G", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "1"}], "}"}]}], "]"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.569310333343567*^9, {3.5693103668177643`*^9, 3.5693103741150427`*^9}, 
   3.569310405309493*^9, {3.569310460039116*^9, 3.569310468954261*^9}, {
   3.569310524402162*^9, 3.5693105603600273`*^9}, {3.569310596842187*^9, 
   3.569310604770582*^9}, 3.569311210936098*^9, 3.569311665015164*^9, {
   3.570677408926464*^9, 3.5706774318744*^9}, 3.5706789597512074`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteRules", "[", 
  RowBox[{"list", ",", "\"\<box\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.5693112205716677`*^9, 3.56931126705503*^9}, {
  3.569311432026888*^9, 3.569311450607785*^9}, {3.569311521970628*^9, 
  3.5693115222318087`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Input: \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\", output: \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Input: ", 3, ", output: ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569311245538805*^9, 3.569311267381706*^9}, {
   3.5693113125741*^9, 3.569311389546288*^9}, {3.569311438054574*^9, 
   3.56931145092276*^9}, 3.569311537298027*^9, 3.570678961280202*^9}],

Cell[BoxData["\<\"Saving rules\"\>"], "Print",
 CellChangeTimes->{{3.569311245538805*^9, 3.569311267381706*^9}, {
   3.5693113125741*^9, 3.569311389546288*^9}, {3.569311438054574*^9, 
   3.56931145092276*^9}, 3.569311537298027*^9, 3.570678961310234*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData["Quit"], "Input",
 CellChangeTimes->{{3.570678913559128*^9, 3.570678914763297*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.569310056056975*^9, 3.569310064345089*^9}, {
  3.5706771070536823`*^9, 3.570677119802376*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "[", "\"\<FIRE_4.0.0.m\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.569308660505506*^9, 3.5693086884557667`*^9}, 
   3.5693100901292753`*^9, {3.570677122771185*^9, 3.570677124671975*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"FIRE, version 4.0.0\"\>"], "Print",
 CellChangeTimes->{
  3.569308688804391*^9, {3.569308815833359*^9, 3.569308851445272*^9}, 
   3.5693089726905737`*^9, 3.569310066320315*^9, {3.569310098023608*^9, 
   3.56931015079423*^9}, 3.569310184348373*^9, 3.569310509079418*^9, 
   3.5693105871392803`*^9, 3.56931119620444*^9, 3.569311310674163*^9, 
   3.569311531679481*^9, 3.5693127543194036`*^9, 3.569312956443667*^9, 
   3.5693129891015873`*^9, 3.56931304471805*^9, 3.56931317070273*^9, 
   3.569313412508919*^9, 3.570677125164794*^9, 3.5706773336398067`*^9, 
   3.5706789356640253`*^9, 3.570678966046068*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"UsingIBP: \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm["UsingIBP: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.569308688804391*^9, {3.569308815833359*^9, 3.569308851445272*^9}, 
   3.5693089726905737`*^9, 3.569310066320315*^9, {3.569310098023608*^9, 
   3.56931015079423*^9}, 3.569310184348373*^9, 3.569310509079418*^9, 
   3.5693105871392803`*^9, 3.56931119620444*^9, 3.569311310674163*^9, 
   3.569311531679481*^9, 3.5693127543194036`*^9, 3.569312956443667*^9, 
   3.5693129891015873`*^9, 3.56931304471805*^9, 3.56931317070273*^9, 
   3.569313412508919*^9, 3.570677125164794*^9, 3.5706773336398067`*^9, 
   3.5706789356640253`*^9, 3.570678966083733*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"DatabaseUsage: \"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["DatabaseUsage: ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.569308688804391*^9, {3.569308815833359*^9, 3.569308851445272*^9}, 
   3.5693089726905737`*^9, 3.569310066320315*^9, {3.569310098023608*^9, 
   3.56931015079423*^9}, 3.569310184348373*^9, 3.569310509079418*^9, 
   3.5693105871392803`*^9, 3.56931119620444*^9, 3.569311310674163*^9, 
   3.569311531679481*^9, 3.5693127543194036`*^9, 3.569312956443667*^9, 
   3.5693129891015873`*^9, 3.56931304471805*^9, 3.56931317070273*^9, 
   3.569313412508919*^9, 3.570677125164794*^9, 3.5706773336398067`*^9, 
   3.5706789356640253`*^9, 3.570678966127061*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"UsingFermat: \"\>", "\[InvisibleSpace]", "False"}],
  SequenceForm["UsingFermat: ", False],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.569308688804391*^9, {3.569308815833359*^9, 3.569308851445272*^9}, 
   3.5693089726905737`*^9, 3.569310066320315*^9, {3.569310098023608*^9, 
   3.56931015079423*^9}, 3.569310184348373*^9, 3.569310509079418*^9, 
   3.5693105871392803`*^9, 3.56931119620444*^9, 3.569311310674163*^9, 
   3.569311531679481*^9, 3.5693127543194036`*^9, 3.569312956443667*^9, 
   3.5693129891015873`*^9, 3.56931304471805*^9, 3.56931317070273*^9, 
   3.569313412508919*^9, 3.570677125164794*^9, 3.5706773336398067`*^9, 
   3.5706789356640253`*^9, 3.5706789661691647`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LeeIdeas: \"\>", "\[InvisibleSpace]", "True"}],
  SequenceForm["LeeIdeas: ", True],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.569308688804391*^9, {3.569308815833359*^9, 3.569308851445272*^9}, 
   3.5693089726905737`*^9, 3.569310066320315*^9, {3.569310098023608*^9, 
   3.56931015079423*^9}, 3.569310184348373*^9, 3.569310509079418*^9, 
   3.5693105871392803`*^9, 3.56931119620444*^9, 3.569311310674163*^9, 
   3.569311531679481*^9, 3.5693127543194036`*^9, 3.569312956443667*^9, 
   3.5693129891015873`*^9, 3.56931304471805*^9, 3.56931317070273*^9, 
   3.569313412508919*^9, 3.570677125164794*^9, 3.5706773336398067`*^9, 
   3.5706789356640253`*^9, 3.570678966201277*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LoadSBases", "[", 
   RowBox[{"\"\<box\>\"", ",", "2"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.569310117653887*^9, 3.56931015546128*^9}}],

Cell[BoxData["\<\"SBases loaded\"\>"], "Print",
 CellChangeTimes->{{3.569310127909254*^9, 3.569310185613509*^9}, 
   3.569310510083799*^9, 3.5693105874852457`*^9, 3.56931119848715*^9, 
   3.5693133675879383`*^9, 3.569313413845705*^9, 3.570677127446867*^9, 
   3.570677335159953*^9, 3.570678936252898*^9, 3.5706789669198847`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Burn", "[", "]"}]], "Input",
 CellChangeTimes->{{3.569310109559018*^9, 3.569310110532069*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.5693101117700987`*^9, 3.569310128917901*^9}, 
   3.5693101867006197`*^9, 3.569310510850979*^9, 3.5693105884579563`*^9, 
   3.569311199320209*^9, 3.5693133683323107`*^9, 3.5693134147014427`*^9, 
   3.570677128270722*^9, 3.570677336123269*^9, 3.5706789369067173`*^9, 
   3.570678967572774*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"LoadRules", "[", 
  RowBox[{"\"\<box\>\"", ",", "2"}], "]"}]], "Input",
 CellChangeTimes->{{3.5693121793495007`*^9, 3.5693121852671423`*^9}, {
  3.569313373772992*^9, 3.56931337632373*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"F", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}]}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"EVALUATING \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}]}], "}"}]}],
  SequenceForm["EVALUATING ", {2, {2, 2, 2, 2}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678980974668*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,1,1,1}}\"\>"}],
  SequenceForm["Working in sector ", 1, "/", 11, ": ", "{2,{1,1,1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678980995482*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 1, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981001605*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"4", ",", "0"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{4, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981022893*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.5706789810316963`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "16", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017982`4.706382986825263", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 16, " IBP's: ", 
   0.017982`4.706382986825263, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981039666*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "14", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.072251`5.310388855879243", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  14, " new relations produced: ", 0.072251`5.310388855879243, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981067802*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678981075211*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "25", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.020615`4.765728332633346", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 25, " IBP's: ", 
   0.020615`4.765728332633346, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981088675*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.078552`5.346702240515587", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.078552`5.346702240515587, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.57067898116748*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.5706789811757183`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "44", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.035695`5.004152379790583", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 44, " IBP's: ", 
   0.035695`5.004152379790583, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981203374*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IRREDUCIBLE INTEGRAL: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["IRREDUCIBLE INTEGRAL: ", {2, {1, 1, 1, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789812633953`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "15", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.060035`5.229949508465739", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  15, " new relations produced: ", 0.060035`5.229949508465739, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981275187*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{3.570678981283888*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,1,1,-1}}\"\>"}],
  SequenceForm["Working in sector ", 2, "/", 11, ": ", "{2,{1,1,1,-1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981291213*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 13, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981298751*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "0"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{3, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789813060427`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.57067898131341*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "27", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.020687`4.767242507945544", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 27, " IBP's: ", 
   0.020687`4.767242507945544, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981320565*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.074626`5.324435157285947", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  23, " new relations produced: ", 0.074626`5.324435157285947, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981374363*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678981382359*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "33", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.02372`4.826659678188198", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 33, " IBP's: ", 
   0.02372`4.826659678188198, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981399331*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.022934`4.812024801667912", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  8, " new relations produced: ", 0.022934`4.812024801667912, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981421411*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{3.57067898142772*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{-1,1,1,1}}\"\>"}],
  SequenceForm["Working in sector ", 3, "/", 11, ": ", "{2,{-1,1,1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.57067898143454*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 8, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981441255*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{2, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981448138*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678981455001*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "28", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.01935`4.738225962850902", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 28, " IBP's: ", 
   0.01935`4.738225962850902, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981461205*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.078003`5.343656299499158", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  23, " new relations produced: ", 0.078003`5.343656299499158, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789815307913`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678981541142*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "36", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.023203`4.817089133525439", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 36, " IBP's: ", 
   0.023203`4.817089133525439, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981554235*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "18", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.059118`5.223264726669341", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  18, " new relations produced: ", 0.059118`5.223264726669341, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981613662*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{3.570678981620509*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,-1,1,1}}\"\>"}],
  SequenceForm["Working in sector ", 4, "/", 11, ": ", "{2,{1,-1,1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981626771*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "13", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 13, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789816340113`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "0"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{3, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981640564*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678981647552*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "27", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.019595`4.743690261310087", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 27, " IBP's: ", 
   0.019595`4.743690261310087, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981653775*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.08144`5.36238275848865", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  23, " new relations produced: ", 0.08144`5.36238275848865, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981729066*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678981736225*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "34", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.026182`4.869547812020411", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 34, " IBP's: ", 
   0.026182`4.869547812020411, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981755499*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.063343`5.253243621723404", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.063343`5.253243621723404, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981819141*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{3.570678981830187*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,1,-1,1}}\"\>"}],
  SequenceForm["Working in sector ", 5, "/", 11, ": ", "{2,{1,1,-1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981836039*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "19", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.022156`4.79703634997062", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm[
  19, " new relations produced: ", 0.022156`4.79703634997062, " seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789818481483`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{-1,1,1,-1}}\"\>"}],
  SequenceForm["Working in sector ", 6, "/", 11, ": ", "{2,{-1,1,1,-1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789818550243`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "14", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 14, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981863751*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{3, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981870563*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678981877377*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "31", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.021146`4.77677322136682", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 31, " IBP's: ", 
   0.021146`4.77677322136682, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789818841467`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.073534`5.3180331842559365", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  23, " new relations produced: ", 0.073534`5.3180331842559365, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789819532843`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{3.570678981960226*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "28", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.01865`4.722223829640674", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 28, " IBP's: ", 
   0.01865`4.722223829640674, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678981972064*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.084911`5.380508949109164", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.084911`5.380508949109164, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.57067898205715*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.5706789820645857`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "26", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.025201`4.852962767843588", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 26, " IBP's: ", 
   0.025201`4.852962767843588, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789820826178`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.068997`5.290375201453948", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.068997`5.290375201453948, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982151752*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{3.5706789821590242`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "20", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.013633`4.586136428206855", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 20, " IBP's: ", 
   0.013633`4.586136428206855, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982166462*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "15", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.076536`5.3354107544505345", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  15, " new relations produced: ", 0.076536`5.3354107544505345, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982242466*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678982249627*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "33", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.02564`4.860463014342748", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 33, " IBP's: ", 
   0.02564`4.860463014342748, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982268256*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "14", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.046183`5.116027134314626", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  14, " new relations produced: ", 0.046183`5.116027134314626, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982314563*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{3.570678982321177*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,-1,1,-1}}\"\>"}],
  SequenceForm["Working in sector ", 7, "/", 11, ": ", "{2,{1,-1,1,-1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982327663*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "12", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 12, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789823348627`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{3, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982341426*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678982353503*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "31", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.019879`4.749939527208915", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 31, " IBP's: ", 
   0.019879`4.749939527208915, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982359791*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "26", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.074041`5.321017269210943", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  26, " new relations produced: ", 0.074041`5.321017269210943, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982422063*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{3.570678982428981*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "28", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.016892`4.679226066248841", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 28, " IBP's: ", 
   0.016892`4.679226066248841, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982439499*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "21", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.08248`5.3678936457714315", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  21, " new relations produced: ", 0.08248`5.3678936457714315, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789825219927`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.5706789825300817`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "26", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017966`4.705996388840986", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 26, " IBP's: ", 
   0.017966`4.705996388840986, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789825407743`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.012672`4.554390157741389", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  6, " new relations produced: ", 0.012672`4.554390157741389, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982552864*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{3.57067898255904*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{-1,-1,1,1}}\"\>"}],
  SequenceForm["Working in sector ", 8, "/", 11, ": ", "{2,{-1,-1,1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982565956*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 22, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982572691*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "}"}]}],
  SequenceForm["Maximal levels: ", {{3, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982579767*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678982586688*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "32", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.020755`4.76866773121051", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 32, " IBP's: ", 
   0.020755`4.76866773121051, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982593047*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "23", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.082178`5.366300560945877", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  23, " new relations produced: ", 0.082178`5.366300560945877, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982669794*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{3.5706789826812057`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "29", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017803`4.702038185336581", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 29, " IBP's: ", 
   0.017803`4.702038185336581, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789826900587`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.096136`5.434431041660275", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.096136`5.434431041660275, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789827840757`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678982790873*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "28", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017757`4.700914588187488", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 28, " IBP's: ", 
   0.017757`4.700914588187488, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789828020773`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "20", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.081994`5.365327067072022", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  20, " new relations produced: ", 0.081994`5.365327067072022, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982884218*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{3.570678982891012*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "22", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.013891`4.594278504809484", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 22, " IBP's: ", 
   0.013891`4.594278504809484, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.57067898290205*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "15", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.090226`5.406876697661431", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  15, " new relations produced: ", 0.090226`5.406876697661431, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678982988729*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.5706789829991426`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "36", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.024376`4.838507434710586", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 36, " IBP's: ", 
   0.024376`4.838507434710586, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983014278*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "16", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.052305`5.170088199927633", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  16, " new relations produced: ", 0.052305`5.170088199927633, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983065819*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{3.570678983072464*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{-1,1,-1,1}}\"\>"}],
  SequenceForm["Working in sector ", 9, "/", 11, ": ", "{2,{-1,1,-1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983079523*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LAPORTA STARTED: \"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\" integrals for evaluation\"\>"}],
  SequenceForm["LAPORTA STARTED: ", 17, " integrals for evaluation"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983086241*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Maximal levels: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm["Maximal levels: ", {{1, 1}, {4, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789830935583`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678983100741*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "32", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.020672`4.766927489810959", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 32, " IBP's: ", 
   0.020672`4.766927489810959, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789831072273`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "26", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.09254`5.417874488659851", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  26, " new relations produced: ", 0.09254`5.417874488659851, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983194851*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"IRREDUCIBLE INTEGRAL: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm["IRREDUCIBLE INTEGRAL: ", {2, {0, 1, 0, 1}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983201702*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Print",
 CellChangeTimes->{3.570678983210101*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "29", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017609`4.6972796869525615", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 29, " IBP's: ", 
   0.017609`4.6972796869525615, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983216754*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "21", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.103263`5.465489731527726", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  21, " new relations produced: ", 0.103263`5.465489731527726, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983316269*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678983327523*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "28", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.017674`4.698879844153427", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 28, " IBP's: ", 
   0.017674`4.698879844153427, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983336555*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "21", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.083236`5.371856195025133", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  21, " new relations produced: ", 0.083236`5.371856195025133, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983417543*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Print",
 CellChangeTimes->{3.570678983424862*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Preparing points, symmetries and \"\>", "\[InvisibleSpace]", 
   "36", "\[InvisibleSpace]", "\<\" IBP's: \"\>", "\[InvisibleSpace]", 
   "0.022668`4.8069581974654305", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Preparing points, symmetries and ", 36, " IBP's: ", 
   0.022668`4.8069581974654305, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.57067898344067*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.039151`5.044287852838479", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  12, " new relations produced: ", 0.039151`5.044287852838479, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789834798326`*^9}],

Cell[BoxData["\<\"Sector complete\"\>"], "Print",
 CellChangeTimes->{3.570678983486559*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,1,-1,-1}}\"\>"}],
  SequenceForm["Working in sector ", 10, "/", 11, ": ", "{2,{1,1,-1,-1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.5706789834936247`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "9", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.007533`4.328512960928553", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm[
  9, " new relations produced: ", 0.007533`4.328512960928553, " seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983500362*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Working in sector \"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\"/\"\>", "\[InvisibleSpace]", "11", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"{2,{1,-1,-1,1}}\"\>"}],
  SequenceForm["Working in sector ", 11, "/", 11, ": ", "{2,{1,-1,-1,1}}"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983508103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "19", "\[InvisibleSpace]", "\<\" new relations produced: \"\>", 
   "\[InvisibleSpace]", "0.016648`4.672907060699538", 
   "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm[
  19, " new relations produced: ", 0.016648`4.672907060699538, " seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983515771*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"GENERATING \"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\" NEW RELATIONS: \"\>", "\[InvisibleSpace]", 
   "2.54532`6.857287383507789", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "GENERATING ", 28, " NEW RELATIONS: ", 2.54532`6.857287383507789, 
   " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983522681*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SORTING THE LIST OF \"\>", "\[InvisibleSpace]", "421", 
   "\[InvisibleSpace]", "\<\" INTEGRALS: \"\>", "\[InvisibleSpace]", 
   "0.020335`4.759789170236571", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "SORTING THE LIST OF ", 421, " INTEGRALS: ", 0.020335`4.759789170236571, 
   " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983534687*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Substituting \"\>", "\[InvisibleSpace]", "421", 
   "\[InvisibleSpace]", "\<\" values: \"\>", "\[InvisibleSpace]", 
   "0.136934`5.588056288080447", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm[
  "Substituting ", 421, " values: ", 0.136934`5.588056288080447, " seconds."],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983671051*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Total time: \"\>", "\[InvisibleSpace]", 
   "2.706153`6.883897340516375", "\[InvisibleSpace]", "\<\" seconds\"\>"}],
  SequenceForm["Total time: ", 2.706153`6.883897340516375, " seconds"],
  Editable->False]], "Print",
 CellChangeTimes->{3.570678983682907*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "8"}], "+", "d"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "6"}], "+", "d"}], ")"}]}]], 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "7"}], "+", "d"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", "d"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "d"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "824"}], "+", 
       RowBox[{"264", " ", "d"}], "-", 
       RowBox[{"28", " ", 
        SuperscriptBox["d", "2"]}], "+", 
       SuperscriptBox["d", "3"]}], ")"}], " ", 
     RowBox[{"G", "[", 
      RowBox[{"2", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}]}], 
  "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "7"}], "+", "d"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "5"}], "+", "d"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"128", "-", 
     RowBox[{"22", " ", "d"}], "+", 
     SuperscriptBox["d", "2"]}], ")"}], " ", 
   RowBox[{"G", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
    "]"}]}]}]], "Output",
 CellChangeTimes->{3.5706789836890497`*^9}]
}, Open  ]]
},
WindowSize->{631, 750},
WindowMargins->{{Automatic, 324}, {16, Automatic}},
ShowSelection->True,
FrontEndVersion->"7.0 for Linux x86 (64-bit) (October 28, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 96, 1, 32, "Input"],
Cell[644, 23, 240, 5, 32, "Input"],
Cell[CellGroupData[{
Cell[909, 32, 237, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[1171, 40, 117, 1, 24, "Print"],
Cell[1291, 43, 225, 5, 24, "Print"],
Cell[1519, 50, 230, 5, 24, "Print"],
Cell[1752, 57, 234, 5, 24, "Print"],
Cell[1989, 64, 228, 5, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[2244, 73, 1786, 55, 143, "Input"],
Cell[CellGroupData[{
Cell[4055, 132, 710, 21, 121, "Input"],
Cell[4768, 155, 249, 3, 24, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5054, 163, 181, 3, 32, "Input"],
Cell[CellGroupData[{
Cell[5260, 170, 328, 7, 24, "Print"],
Cell[5591, 179, 205, 3, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5845, 188, 194, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[6064, 196, 339, 7, 24, "Print"],
Cell[6406, 205, 367, 8, 24, "Print"],
Cell[6776, 215, 401, 8, 24, "Print"],
Cell[7180, 225, 384, 8, 24, "Print"],
Cell[7567, 235, 378, 8, 24, "Print"],
Cell[7948, 245, 437, 9, 24, "Print"],
Cell[8388, 256, 461, 10, 24, "Print"],
Cell[8852, 268, 459, 10, 24, "Print"],
Cell[9314, 280, 455, 10, 24, "Print"],
Cell[9772, 292, 461, 10, 24, "Print"],
Cell[10236, 304, 483, 11, 24, "Print"],
Cell[10722, 317, 481, 11, 24, "Print"],
Cell[11206, 330, 481, 11, 24, "Print"],
Cell[11690, 343, 479, 11, 24, "Print"],
Cell[12172, 356, 483, 11, 24, "Print"],
Cell[12658, 369, 477, 11, 24, "Print"],
Cell[13138, 382, 341, 7, 24, "Print"],
Cell[13482, 391, 367, 8, 24, "Print"],
Cell[13852, 401, 403, 8, 24, "Print"],
Cell[14258, 411, 382, 8, 24, "Print"],
Cell[14643, 421, 374, 8, 24, "Print"],
Cell[15020, 431, 277, 6, 24, "Print"],
Cell[15300, 439, 210, 3, 24, "Print"],
Cell[15513, 444, 297, 8, 24, "Print"],
Cell[15813, 454, 295, 7, 24, "Print"],
Cell[16111, 463, 295, 7, 24, "Print"],
Cell[16409, 472, 335, 7, 24, "Print"],
Cell[16747, 481, 315, 8, 24, "Print"],
Cell[17065, 491, 315, 8, 24, "Print"],
Cell[17383, 501, 315, 8, 24, "Print"],
Cell[17701, 511, 315, 8, 24, "Print"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18065, 525, 206, 4, 26, "Input"],
Cell[18274, 531, 165, 2, 24, "Print"]
}, Open  ]],
Cell[18454, 536, 98, 1, 32, "Input"],
Cell[18555, 539, 240, 5, 32, "Input"],
Cell[CellGroupData[{
Cell[18820, 548, 235, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[19080, 556, 598, 9, 24, "Print"],
Cell[19681, 567, 706, 13, 24, "Print"],
Cell[20390, 582, 711, 13, 24, "Print"],
Cell[21104, 597, 714, 13, 24, "Print"],
Cell[21821, 612, 707, 13, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22577, 631, 180, 4, 32, "Input"],
Cell[22760, 637, 304, 4, 24, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23101, 646, 118, 2, 32, "Input"],
Cell[23222, 650, 317, 4, 31, "Output"]
}, Open  ]],
Cell[23554, 657, 361, 10, 99, "Input"],
Cell[23918, 669, 373, 8, 77, "Input"],
Cell[CellGroupData[{
Cell[24316, 681, 146, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[24487, 689, 257, 4, 45, "Print"],
Cell[24747, 695, 438, 11, 24, "Print"],
Cell[25188, 708, 503, 10, 24, "Print"],
Cell[25694, 720, 404, 8, 24, "Print"],
Cell[26101, 730, 393, 10, 24, "Print"],
Cell[26497, 742, 215, 5, 24, "Print"],
Cell[26715, 749, 548, 11, 24, "Print"],
Cell[27266, 762, 479, 11, 24, "Print"],
Cell[27748, 775, 215, 5, 24, "Print"],
Cell[27966, 782, 549, 11, 24, "Print"],
Cell[28518, 795, 479, 11, 24, "Print"],
Cell[29000, 808, 215, 5, 24, "Print"],
Cell[29218, 815, 549, 11, 24, "Print"],
Cell[29770, 828, 458, 11, 24, "Print"],
Cell[30231, 841, 479, 11, 24, "Print"],
Cell[30713, 854, 192, 3, 24, "Print"],
Cell[30908, 859, 503, 10, 24, "Print"],
Cell[31414, 871, 408, 8, 24, "Print"],
Cell[31825, 881, 393, 10, 24, "Print"],
Cell[32221, 893, 215, 5, 24, "Print"],
Cell[32439, 900, 549, 11, 24, "Print"],
Cell[32991, 913, 477, 11, 24, "Print"],
Cell[33471, 926, 215, 5, 24, "Print"],
Cell[33689, 933, 549, 11, 24, "Print"],
Cell[34241, 946, 477, 11, 24, "Print"],
Cell[34721, 959, 192, 3, 24, "Print"],
Cell[34916, 964, 505, 10, 24, "Print"],
Cell[35424, 976, 406, 8, 24, "Print"],
Cell[35833, 986, 395, 10, 24, "Print"],
Cell[36231, 998, 215, 5, 24, "Print"],
Cell[36449, 1005, 549, 11, 24, "Print"],
Cell[37001, 1018, 479, 11, 24, "Print"],
Cell[37483, 1031, 215, 5, 24, "Print"],
Cell[37701, 1038, 548, 11, 24, "Print"],
Cell[38252, 1051, 479, 11, 24, "Print"],
Cell[38734, 1064, 192, 3, 24, "Print"],
Cell[38929, 1069, 503, 10, 24, "Print"],
Cell[39435, 1081, 406, 8, 24, "Print"],
Cell[39844, 1091, 392, 10, 24, "Print"],
Cell[40239, 1103, 217, 5, 24, "Print"],
Cell[40459, 1110, 551, 11, 24, "Print"],
Cell[41013, 1123, 479, 11, 24, "Print"],
Cell[41495, 1136, 215, 5, 24, "Print"],
Cell[41713, 1143, 548, 11, 24, "Print"],
Cell[42264, 1156, 481, 11, 24, "Print"],
Cell[42748, 1169, 192, 3, 24, "Print"],
Cell[42943, 1174, 503, 10, 24, "Print"],
Cell[43449, 1186, 479, 11, 24, "Print"],
Cell[43931, 1199, 505, 10, 24, "Print"],
Cell[44439, 1211, 406, 8, 24, "Print"],
Cell[44848, 1221, 395, 10, 24, "Print"],
Cell[45246, 1233, 217, 5, 24, "Print"],
Cell[45466, 1240, 549, 11, 24, "Print"],
Cell[46018, 1253, 479, 11, 24, "Print"],
Cell[46500, 1266, 215, 5, 24, "Print"],
Cell[46718, 1273, 549, 11, 24, "Print"],
Cell[47270, 1286, 477, 11, 24, "Print"],
Cell[47750, 1299, 215, 5, 24, "Print"],
Cell[47968, 1306, 551, 11, 24, "Print"],
Cell[48522, 1319, 479, 11, 24, "Print"],
Cell[49004, 1332, 215, 5, 24, "Print"],
Cell[49222, 1339, 551, 11, 24, "Print"],
Cell[49776, 1352, 479, 11, 24, "Print"],
Cell[50258, 1365, 215, 5, 24, "Print"],
Cell[50476, 1372, 551, 11, 24, "Print"],
Cell[51030, 1385, 481, 11, 24, "Print"],
Cell[51514, 1398, 191, 3, 24, "Print"],
Cell[51708, 1403, 505, 10, 24, "Print"],
Cell[52216, 1415, 406, 8, 24, "Print"],
Cell[52625, 1425, 393, 10, 24, "Print"],
Cell[53021, 1437, 215, 5, 24, "Print"],
Cell[53239, 1444, 549, 11, 24, "Print"],
Cell[53791, 1457, 481, 11, 24, "Print"],
Cell[54275, 1470, 217, 5, 24, "Print"],
Cell[54495, 1477, 549, 11, 24, "Print"],
Cell[55047, 1490, 481, 11, 24, "Print"],
Cell[55531, 1503, 215, 5, 24, "Print"],
Cell[55749, 1510, 551, 11, 24, "Print"],
Cell[56303, 1523, 461, 11, 24, "Print"],
Cell[56767, 1536, 477, 11, 24, "Print"],
Cell[57247, 1549, 192, 3, 24, "Print"],
Cell[57442, 1554, 505, 10, 24, "Print"],
Cell[57950, 1566, 406, 8, 24, "Print"],
Cell[58359, 1576, 393, 10, 24, "Print"],
Cell[58755, 1588, 217, 5, 24, "Print"],
Cell[58975, 1595, 549, 11, 24, "Print"],
Cell[59527, 1608, 479, 11, 24, "Print"],
Cell[60009, 1621, 215, 5, 24, "Print"],
Cell[60227, 1628, 551, 11, 24, "Print"],
Cell[60781, 1641, 481, 11, 24, "Print"],
Cell[61265, 1654, 214, 5, 24, "Print"],
Cell[61482, 1661, 550, 11, 24, "Print"],
Cell[62035, 1674, 481, 11, 24, "Print"],
Cell[62519, 1687, 215, 5, 24, "Print"],
Cell[62737, 1694, 549, 11, 24, "Print"],
Cell[63289, 1707, 481, 11, 24, "Print"],
Cell[63773, 1720, 217, 5, 24, "Print"],
Cell[63993, 1727, 551, 11, 24, "Print"],
Cell[64547, 1740, 477, 11, 24, "Print"],
Cell[65027, 1753, 192, 3, 24, "Print"],
Cell[65222, 1758, 505, 10, 24, "Print"],
Cell[65730, 1770, 406, 8, 24, "Print"],
Cell[66139, 1780, 481, 13, 24, "Print"],
Cell[66623, 1795, 215, 5, 24, "Print"],
Cell[66841, 1802, 549, 11, 24, "Print"],
Cell[67393, 1815, 481, 11, 24, "Print"],
Cell[67877, 1828, 463, 11, 24, "Print"],
Cell[68343, 1841, 217, 5, 24, "Print"],
Cell[68563, 1848, 553, 11, 24, "Print"],
Cell[69119, 1861, 478, 11, 24, "Print"],
Cell[69600, 1874, 215, 5, 24, "Print"],
Cell[69818, 1881, 545, 11, 24, "Print"],
Cell[70366, 1894, 478, 11, 24, "Print"],
Cell[70847, 1907, 215, 5, 24, "Print"],
Cell[71065, 1914, 549, 11, 24, "Print"],
Cell[71617, 1927, 481, 11, 24, "Print"],
Cell[72101, 1940, 192, 3, 24, "Print"],
Cell[72296, 1945, 509, 10, 24, "Print"],
Cell[72808, 1957, 475, 11, 24, "Print"],
Cell[73286, 1970, 509, 10, 24, "Print"],
Cell[73798, 1982, 477, 11, 24, "Print"],
Cell[74278, 1995, 523, 11, 24, "Print"],
Cell[74804, 2008, 533, 11, 24, "Print"],
Cell[75340, 2021, 514, 11, 24, "Print"],
Cell[75857, 2034, 410, 8, 24, "Print"]
}, Open  ]],
Cell[76282, 2045, 2364, 82, 157, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[78683, 2132, 289, 6, 26, "Input"],
Cell[78975, 2140, 685, 19, 31, "Output"]
}, Open  ]],
Cell[79675, 2162, 1590, 52, 143, "Input"],
Cell[CellGroupData[{
Cell[81290, 2218, 131, 2, 32, "Input"],
Cell[81424, 2222, 627, 11, 24, "Print"],
Cell[82054, 2235, 725, 18, 31, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82816, 2258, 266, 5, 32, "Input"],
Cell[CellGroupData[{
Cell[83107, 2267, 447, 8, 24, "Print"],
Cell[83557, 2277, 253, 3, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[83837, 2284, 96, 1, 32, "Input"],
Cell[83936, 2287, 240, 5, 32, "Input"],
Cell[CellGroupData[{
Cell[84201, 2296, 235, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[84461, 2304, 622, 9, 24, "Print"],
Cell[85086, 2315, 731, 13, 24, "Print"],
Cell[85820, 2330, 735, 13, 24, "Print"],
Cell[86558, 2345, 741, 13, 24, "Print"],
Cell[87302, 2360, 731, 13, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[88082, 2379, 180, 4, 32, "Input"],
Cell[88265, 2385, 328, 4, 24, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88630, 2394, 118, 2, 32, "Input"],
Cell[88751, 2398, 345, 5, 31, "Output"]
}, Open  ]],
Cell[89111, 2406, 213, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[89349, 2414, 146, 4, 32, "Input"],
Cell[CellGroupData[{
Cell[89520, 2422, 338, 9, 24, "Print"],
Cell[89861, 2433, 400, 8, 24, "Print"],
Cell[90264, 2443, 303, 6, 24, "Print"],
Cell[90570, 2451, 292, 8, 24, "Print"],
Cell[90865, 2461, 116, 3, 24, "Print"],
Cell[90984, 2466, 448, 9, 24, "Print"],
Cell[91435, 2477, 378, 9, 24, "Print"],
Cell[91816, 2488, 114, 3, 24, "Print"],
Cell[91933, 2493, 448, 9, 24, "Print"],
Cell[92384, 2504, 377, 9, 24, "Print"],
Cell[92764, 2515, 116, 3, 24, "Print"],
Cell[92883, 2520, 448, 9, 24, "Print"],
Cell[93334, 2531, 362, 9, 24, "Print"],
Cell[93699, 2542, 378, 9, 24, "Print"],
Cell[94080, 2553, 91, 1, 24, "Print"],
Cell[94174, 2556, 402, 8, 24, "Print"],
Cell[94579, 2566, 305, 6, 24, "Print"],
Cell[94887, 2574, 294, 8, 24, "Print"],
Cell[95184, 2584, 113, 3, 24, "Print"],
Cell[95300, 2589, 448, 9, 24, "Print"],
Cell[95751, 2600, 378, 9, 24, "Print"],
Cell[96132, 2611, 114, 3, 24, "Print"],
Cell[96249, 2616, 446, 9, 24, "Print"],
Cell[96698, 2627, 376, 9, 24, "Print"],
Cell[97077, 2638, 90, 1, 24, "Print"],
Cell[97170, 2641, 401, 8, 24, "Print"],
Cell[97574, 2651, 303, 6, 24, "Print"],
Cell[97880, 2659, 292, 8, 24, "Print"],
Cell[98175, 2669, 114, 3, 24, "Print"],
Cell[98292, 2674, 446, 9, 24, "Print"],
Cell[98741, 2685, 380, 9, 24, "Print"],
Cell[99124, 2696, 114, 3, 24, "Print"],
Cell[99241, 2701, 448, 9, 24, "Print"],
Cell[99692, 2712, 378, 9, 24, "Print"],
Cell[100073, 2723, 91, 1, 24, "Print"],
Cell[100167, 2726, 402, 8, 24, "Print"],
Cell[100572, 2736, 307, 6, 24, "Print"],
Cell[100882, 2744, 292, 8, 24, "Print"],
Cell[101177, 2754, 114, 3, 24, "Print"],
Cell[101294, 2759, 448, 9, 24, "Print"],
Cell[101745, 2770, 374, 9, 24, "Print"],
Cell[102122, 2781, 114, 3, 24, "Print"],
Cell[102239, 2786, 448, 9, 24, "Print"],
Cell[102690, 2797, 378, 9, 24, "Print"],
Cell[103071, 2808, 91, 1, 24, "Print"],
Cell[103165, 2811, 402, 8, 24, "Print"],
Cell[103570, 2821, 376, 9, 24, "Print"],
Cell[103949, 2832, 406, 8, 24, "Print"],
Cell[104358, 2842, 305, 6, 24, "Print"],
Cell[104666, 2850, 292, 8, 24, "Print"],
Cell[104961, 2860, 114, 3, 24, "Print"],
Cell[105078, 2865, 448, 9, 24, "Print"],
Cell[105529, 2876, 382, 9, 24, "Print"],
Cell[105914, 2887, 114, 3, 24, "Print"],
Cell[106031, 2892, 446, 9, 24, "Print"],
Cell[106480, 2903, 377, 9, 24, "Print"],
Cell[106860, 2914, 116, 3, 24, "Print"],
Cell[106979, 2919, 450, 9, 24, "Print"],
Cell[107432, 2930, 378, 9, 24, "Print"],
Cell[107813, 2941, 116, 3, 24, "Print"],
Cell[107932, 2946, 448, 9, 24, "Print"],
Cell[108383, 2957, 380, 9, 24, "Print"],
Cell[108766, 2968, 114, 3, 24, "Print"],
Cell[108883, 2973, 446, 9, 24, "Print"],
Cell[109332, 2984, 378, 9, 24, "Print"],
Cell[109713, 2995, 91, 1, 24, "Print"],
Cell[109807, 2998, 404, 8, 24, "Print"],
Cell[110214, 3008, 307, 6, 24, "Print"],
Cell[110524, 3016, 292, 8, 24, "Print"],
Cell[110819, 3026, 114, 3, 24, "Print"],
Cell[110936, 3031, 448, 9, 24, "Print"],
Cell[111387, 3042, 378, 9, 24, "Print"],
Cell[111768, 3053, 114, 3, 24, "Print"],
Cell[111885, 3058, 448, 9, 24, "Print"],
Cell[112336, 3069, 380, 9, 24, "Print"],
Cell[112719, 3080, 116, 3, 24, "Print"],
Cell[112838, 3085, 450, 9, 24, "Print"],
Cell[113291, 3096, 376, 9, 24, "Print"],
Cell[113670, 3107, 90, 1, 24, "Print"],
Cell[113763, 3110, 404, 8, 24, "Print"],
Cell[114170, 3120, 305, 6, 24, "Print"],
Cell[114478, 3128, 292, 8, 24, "Print"],
Cell[114773, 3138, 114, 3, 24, "Print"],
Cell[114890, 3143, 446, 9, 24, "Print"],
Cell[115339, 3154, 378, 9, 24, "Print"],
Cell[115720, 3165, 116, 3, 24, "Print"],
Cell[115839, 3170, 450, 9, 24, "Print"],
Cell[116292, 3181, 380, 9, 24, "Print"],
Cell[116675, 3192, 114, 3, 24, "Print"],
Cell[116792, 3197, 450, 9, 24, "Print"],
Cell[117245, 3208, 378, 9, 24, "Print"],
Cell[117626, 3219, 114, 3, 24, "Print"],
Cell[117743, 3224, 447, 9, 24, "Print"],
Cell[118193, 3235, 378, 9, 24, "Print"],
Cell[118574, 3246, 116, 3, 24, "Print"],
Cell[118693, 3251, 448, 9, 24, "Print"],
Cell[119144, 3262, 378, 9, 24, "Print"],
Cell[119525, 3273, 91, 1, 24, "Print"],
Cell[119619, 3276, 404, 8, 24, "Print"],
Cell[120026, 3286, 305, 6, 24, "Print"],
Cell[120334, 3294, 382, 11, 24, "Print"],
Cell[120719, 3307, 114, 3, 24, "Print"],
Cell[120836, 3312, 450, 9, 24, "Print"],
Cell[121289, 3323, 376, 9, 24, "Print"],
Cell[121668, 3334, 360, 9, 24, "Print"],
Cell[122031, 3345, 114, 3, 24, "Print"],
Cell[122148, 3350, 450, 9, 24, "Print"],
Cell[122601, 3361, 378, 9, 24, "Print"],
Cell[122982, 3372, 114, 3, 24, "Print"],
Cell[123099, 3377, 448, 9, 24, "Print"],
Cell[123550, 3388, 378, 9, 24, "Print"],
Cell[123931, 3399, 114, 3, 24, "Print"],
Cell[124048, 3404, 449, 9, 24, "Print"],
Cell[124500, 3415, 380, 9, 24, "Print"],
Cell[124883, 3426, 91, 1, 24, "Print"],
Cell[124977, 3429, 408, 8, 24, "Print"],
Cell[125388, 3439, 374, 9, 24, "Print"],
Cell[125765, 3450, 406, 8, 24, "Print"],
Cell[126174, 3460, 376, 9, 24, "Print"],
Cell[126553, 3471, 418, 9, 24, "Print"],
Cell[126974, 3482, 432, 9, 24, "Print"],
Cell[127409, 3493, 411, 9, 24, "Print"],
Cell[127823, 3504, 309, 6, 24, "Print"]
}, Open  ]],
Cell[128147, 3513, 1415, 50, 95, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
