#ifndef CONSTANTS_H

#define CONSTANTS_H 1

/* Here all constants are defined Now we have:
  0 Pi
  1 PolyGamma[1,1]
  2 PolyGamma[2,1]
  3 PolyGamma[2,2]
*/


#define ID_CONST_PI 'P'
#if ARITHMETIC == NATIVE
#define STR_CONST_PI "3.14159265358979324"
#else
#define STR_CONST_PI "\
3.141592653589793238462643383279502884197169399375105820974944592307816406286\
20899862803482534211706798214808651328230664709384460955058223172535940812848\
11174502841027019385211055596446229489549303819644288109756659334461284756482\
33786783165271201909145648566923460348610454326648213393607260249141273724587\
00660631558817488152092096282925409171536436789259036001133053054882046652138\
41469519415116094330572703657595919530921861173819326117931051185480744623799\
62749567351885752724891227938183011949129833673362440656643086021394946395224\
73719070217986094370277053921717629317675238467481846766940513200056812714526\
35608277857713427577896091736371787214684409012249534301465495853710507922796\
89258923542019956112129021960864034418159813629774771309960518707211349999998\
37297804995105973173281609631859502445945534690830264252230825334468503526193\
11881710100031378387528865875332083814206171776691473035982534904287554687311\
59562863882353787593751957781857780532171226806613001927876611195909216420198\
93809525720106548586327886593615338182796823030195203530185296899577362259941\
38912497217752834791315155748572424541506959508295331168617278558890750983817\
54637464939319255060400927701671139009848824012858361603563707660104710181942\
95559619894676783744944825537977472684710404753464620804668425906949129331367\
70289891521047521620569660240580381501935112533824300355876402474964732639141\
99272604269922796782354781636009341721641219924586315030286182974555706749838\
50549458858692699569092721079750930295532116534498720275596023648066549911988\
18347977535663698074265425278625518184175746728909777727938000816470600161452\
49192173217214772350141441973568548161361157352552133475741849468438523323907\
39414333454776241686251898356948556209921922218427255025425688767179049460165\
34668049886272327917860857843838279679766814541009538837863609506800642251252\
05117392984896084128488626945604241965285022210661186306744278622039194945047\
12371378696095636437191728746776465757396241389086583264599581339047802759009\
94657640789512694683983525957098258226205224894077267194782684826014769909026\
40136394437455305068203496252451749399651431429809190659250937221696461515709\
85838741059788595977297549893016175392846813826868386894277415599185592524595\
39594310499725246808459872736446958486538367362226260991246080512438843904512\
44136549762780797715691435997700129616089441694868555848406353422072225828488\
64815845602850601684273945226746767889525213852254995466672782398645659611635\
48862305774564980355936345681743241125150760694794510965960940252288797108931\
45669136867228748940560101503308617928680920874760917824938589009714909675985\
26136554978189312978482168299894872265880485756401427047755513237964145152374\
62343645428584447952658678210511413547357395231134271661021359695362314429524\
84937187110145765403590279934403742007310578539062198387447808478489683321445\
71386875194350643021845319104848100537061468067491927819119793995206141966342\
87544406437451237181921799983910159195618146751426912397489409071864942319615\
67945208095146550225231603881930142093762137855956638937787083039069792077346\
72218256259966150142150306803844773454920260541466592520149744285073251866600\
21324340881907104863317346496514539057962685610055081066587969981635747363840\
52571459102897064140110971206280439039759515677157700420337869936007230558763\
17635942187312514712053292819182618612586732157919841484882916447060957527069\
57220917567116722910981690915280173506712748583222871835209353965725121083579\
15136988209144421006751033467110314126711136990865851639831501970165151168517\
14376576183515565088490998985998238734552833163550764791853589322618548963213\
29330898570642046752590709154814165498594616371802709819943099244889575712828\
90592323326097299712084433573265489382391193259746366730583604142813883032038\
24903758985243744170291327656180937734440307074692112019130203303801976211011\
00449293215160842444859637669838952286847831235526582131449576857262433441893\
03968642624341077322697802807318915441101044682325271620105265227211166039666\
55730925471105578537634668206531098965269186205647693125705863566201855810072\
93606598764861179102411641820832331342696234"

#endif


/*Header for all PolyGamma's:*/
#define ID_CONST_POLYGAMMA "PolyGamma"

/* N[PolyGamma[1,1],4096]: */
#if ARITHMETIC == NATIVE
#define STR_CONST_POLYGAMMA1_1 "1.6449340668482264364724151"
#else
#define STR_CONST_POLYGAMMA1_1 "\
1.644934066848226436472415166646025189218949901206798437735558229370007470403\
20087383362890061975870530400431896233719067962872468700500778793510294633086\
62768317333093677626050952510068721400547968115587948903608232777619198407564\
55876963235636709710096948902085932008051636478878338846044445184059825145250\
68338763142276587939295880632044721979084773409105902083782895492782638903797\
63583343942045159120818099593454448774587965008808894087011116347106931614618\
42887981548624483590918344875738742839408276028756321434601001357662098204872\
06904000738266356030240228446296303245660971719514277213159512556799861908719\
31543953524106380440721421339654750580158723165839947624349142243348362904887\
00966505986226303410959673655281137167032691149878403435716160577667633306725\
27368942384166408895362275954007727947481271025204983784332300171657448103028\
60434966884794216728433597281997793810008466560780537782885947278625931618664\
58829216065819385923241532580646178120188464977762598497756060938460605146768\
58347256231971018363014798374889621592970276323587457382230067977956793195156\
51996612383618366168655665797003758579395038193467059393114859491596635058620\
85852638106454887958200078974371721569365749082508035204574113928763553094770\
98608239229398667075005258036453403154127390727427228902274797421575212652728\
66790504356086447019522174348296308095407209404388845394174205278719269341962\
28202474975151187413472787517993664733687482075233566088579390765961960790812\
65115910507292195588446135726412526147515780716091751568853276832936656547655\
88128436115113494859670092266296975220677781810295008702914015225183747431377\
21775531790671996700111495476829236420750270534116504905107286118885470775457\
35758547470329579199070871561258124025588530001968988757224397179538111807930\
70896494335953356183275794651103546695668292833094507406208425346300827605686\
18023817523823965946245820792024906373787208530047937996760356554385152131209\
36058934904130754913119590419358775318883805679121713772645707229956351428128\
10658216832092872867483537830128254732917028021436897618019637363184980566899\
58635534106864742593080188336774946986683842894977740270531175358375860747416\
94057376371535251658701871128038616432461784801266713923691585450434446466484\
71950875283006191625838679257789892298444165212547711817391890576286084578861\
36846933529380082474192943243932362646876908674923157609420615024984005693022\
82492390618324351857950190300561751458357165743352232823516661404763912839405\
76264724881002052041812033788626252366555788937763981538291415976032314805706\
59069194458370314020515380582192191729590555397879400078994611984652754147068\
58536500599636626755706156952543177253155438763517276261924978861609650704452\
49636970214088526846826793337277335304510049048440997806284485082110994618287\
76777233591459636784397410313050958712913309068747471161526666904800503285246\
44893289079809995692733023669474446969804089713571409192119442723896924355813\
78274354272335097373721967750814686576663441952446411700179575195463240270033\
85839272975487876396211177093784213345435282443104742352612582132040123036312\
39832733240265497563915405400441369799067662672559215078279750824700784374973\
64993986919795895302438696540685316220558806647674709744582710116043808080019\
62357557135822218926069223767503227756535206400861717801780358070848567257147\
75723335112201204172587317090542527295761171578563616792353885234306759840885\
09039181941283572915859606859411517352815919870332098540687510589658192905746\
19799601216417331549926787703042969191600192448499159646492419275184927324986\
57613414129616002435283015251540332069844203375566169761735533434515381127617\
82303041577387865173576020145899030695462069065351711300188076000520650939052\
15280038907684709946960180841203099745041186671832861186549010385654515361600\
59883800449249452565578776140643897826657742068324119674497513466159628765869\
46213686698711643631275635335149528646004828057278004190419870510081657707240\
65913758398800052034363625348033489869038514910358536857063458009588271270284\
93001099286893599871474688492389263347348542454126887151468675661691706819672\
07525691336022089090287580952299456594716519"
#endif

/* N[PolyGamma[2,1],4096]: */
#if ARITHMETIC == NATIVE
#define STR_CONST_POLYGAMMA2_1 "-2.4041138063191885707994763"
#else
#define STR_CONST_POLYGAMMA2_1 "\
-2.40411380631918857079947632302289998152997258468099776358454311068367641157\
26261803729117472186705162923983155905214388369839919973465664275527936744158\
00322907883565898720133438383151044484988487923127819328206582318191561931029\
30255983681021143051197603087421956220407965506513357520704467396988332362211\
40294315572789994750475705558740619120514037063655800061530942151260976866417\
39423147484761586890063215250635429070888823662356364499437052714183648979975\
92407016671512344045206787571740656262535615980108354697382305074131247411488\
19324434258052546414647229844858260810571107446820661551555961284840486097656\
30420018292053076441392543104041645486700020305896023973802352519033527339963\
43671150469761407439111484694588167190417723332405145707511626158565172974564\
34741113239379790532403755362125840163558467627175365685282486486296056434734\
90134413870152537906086918787500659327275515012494664798469657662154678105536\
04015159687135874230101801005473209422801706700687293444971306303623553236218\
44558382044976793600533213137410381255194775470714888957550758328285476264513\
91463920403749769494209398673132280161386065123707437720145437071896576957724\
90083711092817143112601425018054277269378748336533093315458522234364920726113\
20930600950443406530272782117397715768490082680015234945582743685548217501735\
81003779307927139172861639227459804654986994048324529086784785853455673573114\
31116355479327543825628364493282537326905622110280263346507336836558590745321\
00683037054097605780536631666959184077511969977235734011927462031454344000228\
66953470308376510504932652594405077322851875186698022499089037768917597673064\
75210013724328518569237602274333332700713120200502625504002486930763577045033\
29011347910114772630527531908605629244846035495002335368914299340976068804261\
46048255746308058085023018398817566972402856028081432428930957749635516520841\
33346805010642154051660367626598773394663989168124658079211406381854528136776\
17121681494779136670104188302983466096726609542869165107842443640903312008555\
74456862518631499254053460831837576568961722775553645123245927482627514084911\
98978265905171680429587167564639554234556956344096487333314244660746591882011\
45223960276460517611841259226635587529021914240053156097612186110687265701947\
22636015218705282866044356559571296358557720662467471385779318548505209577357\
68313285243982743338822189364962264627660363535256727708701811117202451864250\
72586191568209058018917787193837970602395461450084918942858021142365302371368\
96634252586107418850071894035792340935472247370947387100569491723967059142719\
46432614931660174806940342149200122008780257167275263215033254353911434130197\
58375789677337561918434406966263828081098382752612570479992722340251106543541\
55830731229162971410736452086637039180342907069394452927861464282407503215974\
26929662162797626235778069182776641463219212200534829308822830893563980929257\
42365314355099673547357102099172075723116550679764987470491384867751836087132\
99252948477325804890261049205172635896033603865269516843529142929381272825727\
92256326313972951480063393410294014248500834429378200323246779602124033582244\
20031474093085121519914051939661220135851415076795331154116440203496361429558\
80293350464486322914536839413563467735072350596843440386262895447136393280787\
63298004030565861839455397980798237830367114448115746688757149980448062786015\
58984992085243611491204556249204314900450811446792532588918604900304396678610\
01107227061427430955861465766809141289992271701444287726186145479288292749272\
97811379933154199291053706971030686959415044782028086753076361297218959477399\
17828673721098007480792987394572535999777864525508979285251786803226655069046\
89363724928174739014388020653783387924643321039096073234454011886496161645605\
80057651013605624630302876629612403008637648343653441279245305531523370664841\
23950740593069915849514211045368460948775966906463840883953643563448153583458\
29251357320264919880964513411743872958840262058372872615601826247457942510526\
43965013956766673559087743802767906310293028356903907714475863302253651510168\
24963316789483778110333974775812203437566033040833883648257100834364451008108\
598209638526560829726669605390799847430314948"
#endif

/* N[PolyGamma[2,2],4096]: */
#if ARITHMETIC == NATIVE
#define STR_CONST_POLYGAMMA2_2 "-0.4041138063191885707994763"
#else
#define STR_CONST_POLYGAMMA2_2 "\
-0.40411380631918857079947632302289998152997258468099776358454311068367641157\
26261803729117472186705162923983155905214388369839919973465664275527936744158\
00322907883565898720133438383151044484988487923127819328206582318191561931029\
30255983681021143051197603087421956220407965506513357520704467396988332362211\
40294315572789994750475705558740619120514037063655800061530942151260976866417\
39423147484761586890063215250635429070888823662356364499437052714183648979975\
92407016671512344045206787571740656262535615980108354697382305074131247411488\
19324434258052546414647229844858260810571107446820661551555961284840486097656\
30420018292053076441392543104041645486700020305896023973802352519033527339963\
43671150469761407439111484694588167190417723332405145707511626158565172974564\
34741113239379790532403755362125840163558467627175365685282486486296056434734\
90134413870152537906086918787500659327275515012494664798469657662154678105536\
04015159687135874230101801005473209422801706700687293444971306303623553236218\
44558382044976793600533213137410381255194775470714888957550758328285476264513\
91463920403749769494209398673132280161386065123707437720145437071896576957724\
90083711092817143112601425018054277269378748336533093315458522234364920726113\
20930600950443406530272782117397715768490082680015234945582743685548217501735\
81003779307927139172861639227459804654986994048324529086784785853455673573114\
31116355479327543825628364493282537326905622110280263346507336836558590745321\
00683037054097605780536631666959184077511969977235734011927462031454344000228\
66953470308376510504932652594405077322851875186698022499089037768917597673064\
75210013724328518569237602274333332700713120200502625504002486930763577045033\
29011347910114772630527531908605629244846035495002335368914299340976068804261\
46048255746308058085023018398817566972402856028081432428930957749635516520841\
33346805010642154051660367626598773394663989168124658079211406381854528136776\
17121681494779136670104188302983466096726609542869165107842443640903312008555\
74456862518631499254053460831837576568961722775553645123245927482627514084911\
98978265905171680429587167564639554234556956344096487333314244660746591882011\
45223960276460517611841259226635587529021914240053156097612186110687265701947\
22636015218705282866044356559571296358557720662467471385779318548505209577357\
68313285243982743338822189364962264627660363535256727708701811117202451864250\
72586191568209058018917787193837970602395461450084918942858021142365302371368\
96634252586107418850071894035792340935472247370947387100569491723967059142719\
46432614931660174806940342149200122008780257167275263215033254353911434130197\
58375789677337561918434406966263828081098382752612570479992722340251106543541\
55830731229162971410736452086637039180342907069394452927861464282407503215974\
26929662162797626235778069182776641463219212200534829308822830893563980929257\
42365314355099673547357102099172075723116550679764987470491384867751836087132\
99252948477325804890261049205172635896033603865269516843529142929381272825727\
92256326313972951480063393410294014248500834429378200323246779602124033582244\
20031474093085121519914051939661220135851415076795331154116440203496361429558\
80293350464486322914536839413563467735072350596843440386262895447136393280787\
63298004030565861839455397980798237830367114448115746688757149980448062786015\
58984992085243611491204556249204314900450811446792532588918604900304396678610\
01107227061427430955861465766809141289992271701444287726186145479288292749272\
97811379933154199291053706971030686959415044782028086753076361297218959477399\
17828673721098007480792987394572535999777864525508979285251786803226655069046\
89363724928174739014388020653783387924643321039096073234454011886496161645605\
80057651013605624630302876629612403008637648343653441279245305531523370664841\
23950740593069915849514211045368460948775966906463840883953643563448153583458\
29251357320264919880964513411743872958840262058372872615601826247457942510526\
43965013956766673559087743802767906310293028356903907714475863302253651510168\
24963316789483778110333974775812203437566033040833883648257100834364451008108\
598209638526560829726669605390799847430314948"
#endif

/* N[PolyGamma[2,3],4096]: */
#if ARITHMETIC == NATIVE
#define STR_CONST_POLYGAMMA2_3 "-0.1541138063191885707994763"
#else
#define STR_CONST_POLYGAMMA2_3 "\
-0.15411380631918857079947632302289998152997258468099776358454311068367641157\
26261803729117472186705162923983155905214388369839919973465664275527936744158\
00322907883565898720133438383151044484988487923127819328206582318191561931029\
30255983681021143051197603087421956220407965506513357520704467396988332362211\
40294315572789994750475705558740619120514037063655800061530942151260976866417\
39423147484761586890063215250635429070888823662356364499437052714183648979975\
92407016671512344045206787571740656262535615980108354697382305074131247411488\
19324434258052546414647229844858260810571107446820661551555961284840486097656\
30420018292053076441392543104041645486700020305896023973802352519033527339963\
43671150469761407439111484694588167190417723332405145707511626158565172974564\
34741113239379790532403755362125840163558467627175365685282486486296056434734\
90134413870152537906086918787500659327275515012494664798469657662154678105536\
04015159687135874230101801005473209422801706700687293444971306303623553236218\
44558382044976793600533213137410381255194775470714888957550758328285476264513\
91463920403749769494209398673132280161386065123707437720145437071896576957724\
90083711092817143112601425018054277269378748336533093315458522234364920726113\
20930600950443406530272782117397715768490082680015234945582743685548217501735\
81003779307927139172861639227459804654986994048324529086784785853455673573114\
31116355479327543825628364493282537326905622110280263346507336836558590745321\
00683037054097605780536631666959184077511969977235734011927462031454344000228\
66953470308376510504932652594405077322851875186698022499089037768917597673064\
75210013724328518569237602274333332700713120200502625504002486930763577045033\
29011347910114772630527531908605629244846035495002335368914299340976068804261\
46048255746308058085023018398817566972402856028081432428930957749635516520841\
33346805010642154051660367626598773394663989168124658079211406381854528136776\
17121681494779136670104188302983466096726609542869165107842443640903312008555\
74456862518631499254053460831837576568961722775553645123245927482627514084911\
98978265905171680429587167564639554234556956344096487333314244660746591882011\
45223960276460517611841259226635587529021914240053156097612186110687265701947\
22636015218705282866044356559571296358557720662467471385779318548505209577357\
68313285243982743338822189364962264627660363535256727708701811117202451864250\
72586191568209058018917787193837970602395461450084918942858021142365302371368\
96634252586107418850071894035792340935472247370947387100569491723967059142719\
46432614931660174806940342149200122008780257167275263215033254353911434130197\
58375789677337561918434406966263828081098382752612570479992722340251106543541\
55830731229162971410736452086637039180342907069394452927861464282407503215974\
26929662162797626235778069182776641463219212200534829308822830893563980929257\
42365314355099673547357102099172075723116550679764987470491384867751836087132\
99252948477325804890261049205172635896033603865269516843529142929381272825727\
92256326313972951480063393410294014248500834429378200323246779602124033582244\
20031474093085121519914051939661220135851415076795331154116440203496361429558\
80293350464486322914536839413563467735072350596843440386262895447136393280787\
63298004030565861839455397980798237830367114448115746688757149980448062786015\
58984992085243611491204556249204314900450811446792532588918604900304396678610\
01107227061427430955861465766809141289992271701444287726186145479288292749272\
97811379933154199291053706971030686959415044782028086753076361297218959477399\
17828673721098007480792987394572535999777864525508979285251786803226655069046\
89363724928174739014388020653783387924643321039096073234454011886496161645605\
80057651013605624630302876629612403008637648343653441279245305531523370664841\
23950740593069915849514211045368460948775966906463840883953643563448153583458\
29251357320264919880964513411743872958840262058372872615601826247457942510526\
43965013956766673559087743802767906310293028356903907714475863302253651510168\
24963316789483778110333974775812203437566033040833883648257100834364451008108\
598209638526560829726669605390799847430314948"
#endif

/* N[PolyGamma[2,4],4096]: */
#if ARITHMETIC == NATIVE
#define STR_CONST_POLYGAMMA2_4 "-0.0800397322451144967254022"
#else
#define STR_CONST_POLYGAMMA2_4 "\
-0.08003973224511449672540224894882590745589851060692368951046903660960233749\
85521062988376731445964422183242415164473647629099179232724923534787196003417\
26248833809491824646059364309076970410914413849053745254132508244117487856955\
22848576273613735643790195680014548813000558099105950113297059989580924954803\
99553574832049254009734964817999878379773296322915059320790201410520236125676\
65349073410687512815989141176561354996814749588282290425362978640109574905901\
84999609264104936637799380164333248855128208572700947289974897666723840004080\
78583693517311805673906489104117520069830366706079920810815220544099745356915\
56345944217979002367318469029967571412625946231821949899728278444959453265889\
36263743062354000031704077287180759783010315924997738300104218751157765567156\
94000372498639049791663014621385099422817726886434624944541745745555315693994\
16060339796078463832012844713426585253201440938420590724395583588080604031461\
96607752279728466822694393598065802015394299293279886037563898896216145828811\
03817641304236052859792472396669640514454034729974148216810017587544735523773\
17389846329675695420135324599058206087311991049633363646071362997822502883650\
82676303685409735705194017610646869861971340929125685908051114826957513318705\
80189860209702665789532041376656975027749341939274494204842002944807476760995\
06929705233853065098787565153385730580912919974250455012710711779381599499040\
23708948071920136418220957085875129919498214702872855939099929429151183337913\
59942296313356865039795890926218443336771229236494993271186721290713603259487\
92879396234302436430858578520331003248777801112623948425014963694843523598990\
67802606316921111161830194866925925293305712793095218096595079523356169637625\
88270607169374031889786791167864888504105294754261594628173558600235328063520\
71974181672233984010948944324743492898328781954007358354856883675561442446767\
25939397603234746644252960219191365987256581760717250671803998974447120729368\
76380940754038395929363447562242725355985868802128424367101702900162571267815\
00382788444557425179979386757763502494887648701479571049171853408553440010837\
91570858497764273022179760157232146827149548936689079925906837253339184474604\
04483219535719776871100518485894846788281173499312415356871445369946524961206\
48561941144631208791970282485497222284483646588393397311705244474431135503283\
60905877836575335931414781957554857220252956127849320301294403709795044456843\
31845450827468317278177046453097229861654720709344178202117280401624561630628\
22560178512033344775997819961718266861398173296873313026495417649892985068645\
39025207524252767399532934741792714601372849759867855807625846946504026722790\
17635048936596821177693666225523087340357642011871829739251981599510365802800\
81756657155088897336662378012562965106268832995320378853787390208333429141900\
19522254755390218828370661775369234055811804793127421901415423486156573521850\
01624573614358932806616361358431334982375809939024246729750644127011095346392\
25178874403251730816186975131098561821959529791195442769455068855307198751653\
84848918906565544072655986002886606841093427021970792915839372194716626174836\
79290733352344380779173311198920479395110674336054590413375699462755620688818\
06219276390412248840462765339489393660998276522769366312188821373062319206713\
55890596623158454432047990573390830422959707040708339281349742573040655378608\
18244251344502870750463815508463574159710070706051791848177864159563655937869\
27033152987353356881787391692735067215918197627370213652112071405214218675198\
90403972525746791883646299563623279552007637374620679345668953889811552069991\
77087932980357266740052246653831795259037123784768238544511046062485914328306\
15289650854100664940313946579709313850569246965021999160379937812422087571531\
72650243606198217222895469222204995601230240936246033871837898124115963257433\
83209999852329175108773470304627720208035226165723100143212902822707412842717\
55177283246190845806890439337669798884766187984298798541527752173383868436452\
36557606549359266151680336395360498902885620949496500307068455894846244102760\
84222576048743037369593234035071462696825292300093142907516360093623710267367\
857468897785820088985928864658523033484135182"
#endif

/* N[PolyGamma[3,1],4096]: */
#if ARITHMETIC == NATIVE
#define STR_CONST_POLYGAMMA3_1 "6.4939394022668291490960222"
#else
#define STR_CONST_POLYGAMMA3_1 "\
6.493939402266829149096022179247007416648505711512361446097857292664723697121\
81307934145781565019950339794488344825645448750442944742027209569202108829731\
52425267008854650221759571324089570516416254130373162425037026704720957812065\
04398456401216047134351770027716770722006975342813175761689325010197901792894\
12319274373434907987735300693996273529612072592102697261082318497089317879738\
48355314508731948571353948494530059099299359777397888324122993133965440264878\
87283462951065150281701531508479324618857357886611766517578440217481300180118\
73665520085899940264412488988428544657452743939678129753657949653355806092892\
38985260780500298291473281776299206715555015863273027953991132801686165831487\
61958832527314266882280181277594110306179933572214371015251642203769652955501\
94092795329775367360890307152755869042104296794124294151720457095116415298092\
57276602762478340504207669878232255762169600946213956753814769906668646616119\
36539441552540950178334381165318177159294176735052166057542144661132068444513\
47671203152257154021998509556857767974641472893625754773653875786309363224451\
99414255440503644226969793287285470705970207798391758326785260505982466296572\
94392309667683326430774297208384098503764012951509635922389480857442386467343\
39067773324960767417307141065325720265939903787403605098559895421989366200281\
23700312652771899767807220739275639070519904299751966111658382256672752218455\
05125579789528282585725866999146339767024249533607171602159346177527762608128\
86576619293636509670091740474879619560290886056944639798719113768451358082765\
40099234396061238262145235931604669464385324828608630612879431543164500983682\
63924445257052075980879002930966014879392930747367059565964331705493912132893\
37156341032400296170716214600734760361344288384704849534621649115294981295653\
06295592793616191337892039697473373640670029119000881791339383201208019714219\
85806027802253725897868174052429791502398623647060779157733829723042716028502\
98621294058574849792501308088347553964095481796771829669997577772412439121919\
99097263415793870153354817543659263819219929579573515281714161127242694212040\
12892832202541475716957423917857580445695058713313595955875159628112006164412\
47508705527442448764992849346371016457066420712840946784374976905774533782372\
63232173079120921281048196820644302775605209212291545997595611974454226896673\
32482586789900324840160550372163432565155378981532824062895808908116419091420\
89651560846958860884554020714881342274900442593637872469231968527195677949808\
60758248033453841317607281982839164334472421082934948872510199490020714855664\
76807579145018518274068923468333113092815691659293730982718493051717067834645\
29703981195135838763775406834081404779661661252951827618922176900636954458423\
30694017253894671740566029360668729576005821348897212790132477165208503290063\
55216191742404498773100328375453062208565070616477912562030463164016622913221\
11646548596543537782841332263618521156411448996602243836951908490256095091251\
00745735862132146409531097115678434881680698901838535737019219035973600914507\
31145092988201041427825816605673433127361290909606482485703168709350229427725\
61307768777103919648594131435564256097210142453448638790533907622819052623292\
04325014390074665902630790331917855034271225653644099395936596623731487617540\
27378782172305054560153950283107995572890408801289910584636182117253390486757\
47946632149564976948898626683275030209681087679709210468696225589046957090175\
78541207325986539826517665637538234305043531159932871255794737167896387521931\
31651765689375590922474229265543357143038431049297647300204038293546566722734\
51906995488479874748385879651731170175203170614502115077808313858813047350097\
01559491140722830222421363814974890450379777824020319154688097989873867008000\
34461429355495372242941886213991546400473138865732438885484413268806006838679\
42887146564399685403604664088487610403364291117041400086469262113822936856869\
20920392576226890147148401563456900246944480085460457277851493508978707765871\
50345551089744832402662265776907474932370439195846632776430925013599926939144\
45489652076842554885060153463680837410590681841470806485434054173842325310176\
95761506195548525800544962558531731340244094"

#endif

/* N[PolyGamma[3,2],4096]: */
#if ARITHMETIC == NATIVE
#define STR_CONST_POLYGAMMA3_2 "0.4939394022668291490960222"
#else
#define STR_CONST_POLYGAMMA3_2 "\
0.493939402266829149096022179247007416648505711512361446097857292664723697121\
81307934145781565019950339794488344825645448750442944742027209569202108829731\
52425267008854650221759571324089570516416254130373162425037026704720957812065\
04398456401216047134351770027716770722006975342813175761689325010197901792894\
12319274373434907987735300693996273529612072592102697261082318497089317879738\
48355314508731948571353948494530059099299359777397888324122993133965440264878\
87283462951065150281701531508479324618857357886611766517578440217481300180118\
73665520085899940264412488988428544657452743939678129753657949653355806092892\
38985260780500298291473281776299206715555015863273027953991132801686165831487\
61958832527314266882280181277594110306179933572214371015251642203769652955501\
94092795329775367360890307152755869042104296794124294151720457095116415298092\
57276602762478340504207669878232255762169600946213956753814769906668646616119\
36539441552540950178334381165318177159294176735052166057542144661132068444513\
47671203152257154021998509556857767974641472893625754773653875786309363224451\
99414255440503644226969793287285470705970207798391758326785260505982466296572\
94392309667683326430774297208384098503764012951509635922389480857442386467343\
39067773324960767417307141065325720265939903787403605098559895421989366200281\
23700312652771899767807220739275639070519904299751966111658382256672752218455\
05125579789528282585725866999146339767024249533607171602159346177527762608128\
86576619293636509670091740474879619560290886056944639798719113768451358082765\
40099234396061238262145235931604669464385324828608630612879431543164500983682\
63924445257052075980879002930966014879392930747367059565964331705493912132893\
37156341032400296170716214600734760361344288384704849534621649115294981295653\
06295592793616191337892039697473373640670029119000881791339383201208019714219\
85806027802253725897868174052429791502398623647060779157733829723042716028502\
98621294058574849792501308088347553964095481796771829669997577772412439121919\
99097263415793870153354817543659263819219929579573515281714161127242694212040\
12892832202541475716957423917857580445695058713313595955875159628112006164412\
47508705527442448764992849346371016457066420712840946784374976905774533782372\
63232173079120921281048196820644302775605209212291545997595611974454226896673\
32482586789900324840160550372163432565155378981532824062895808908116419091420\
89651560846958860884554020714881342274900442593637872469231968527195677949808\
60758248033453841317607281982839164334472421082934948872510199490020714855664\
76807579145018518274068923468333113092815691659293730982718493051717067834645\
29703981195135838763775406834081404779661661252951827618922176900636954458423\
30694017253894671740566029360668729576005821348897212790132477165208503290063\
55216191742404498773100328375453062208565070616477912562030463164016622913221\
11646548596543537782841332263618521156411448996602243836951908490256095091251\
00745735862132146409531097115678434881680698901838535737019219035973600914507\
31145092988201041427825816605673433127361290909606482485703168709350229427725\
61307768777103919648594131435564256097210142453448638790533907622819052623292\
04325014390074665902630790331917855034271225653644099395936596623731487617540\
27378782172305054560153950283107995572890408801289910584636182117253390486757\
47946632149564976948898626683275030209681087679709210468696225589046957090175\
78541207325986539826517665637538234305043531159932871255794737167896387521931\
31651765689375590922474229265543357143038431049297647300204038293546566722734\
51906995488479874748385879651731170175203170614502115077808313858813047350097\
01559491140722830222421363814974890450379777824020319154688097989873867008000\
34461429355495372242941886213991546400473138865732438885484413268806006838679\
42887146564399685403604664088487610403364291117041400086469262113822936856869\
20920392576226890147148401563456900246944480085460457277851493508978707765871\
50345551089744832402662265776907474932370439195846632776430925013599926939144\
45489652076842554885060153463680837410590681841470806485434054173842325310176\
95761506195548525800544962558531731340619476"
#endif

#endif
